
import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Button, Input, message } from "antd";
import LeftStructureTree from "./LeftStructureTree";
import AddOrEditPostGroupModal from "../modal/AddOrEditPostGroupModal";
import UserTable from "./UserTable";

import "./PostGroupTabCon.less";
const { Search } = Input;
function CustomGroupTabCon() {
  const [postGroupTreeData, setPostGroupTreeData] = useState([]);
  return (
    <div className="post-group-tab-con">
      <LeftStructureTree
          treeData={postGroupTreeData}
          treeType={"customGroupTab"}
          editPostGroup={(record)=>editPostGroup(record)}
          addPostGroup={(record)=>addPostGroup(record)}
        />
      <div className="table-con">
        <div className="operate-area">
          <Button type="primary" className="add-user-btn">
            添加学员
          </Button>
          <Button className="del-user-btn">移出学员</Button>
        </div>
        <UserTable />
      </div>
    </div>
  );
}

export default withRouter(CustomGroupTabCon);

