import React from "react";
import { HashRouter as Router, withRouter, Link } from "react-router-dom";
import "./Menu.less";
import classNames from "classnames";
import { Menu, Icon, Modal, Badge } from "antd";
import Bus from '@/core/bus'
const MenuItem = Menu.Item;

const SubMenu = Menu.SubMenu;

const mircoLink = ["cloudclass"];
window.Router = Router;

class Menus extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      menuType: 1, // 目录的宽屏和窄屏模式
    };
  }
  async componentDidMount() {
    Bus.bind("menuTypeChange", (menuType) => {
      if (menuType) {
        this.setState({ menuType });
      } else {
        this.setState({ openKeys: [] }, () => this.setState({ menuType }));
      }
    })
  }
  render() {
    return (
      <div id="left-container"
      className={
        this.state.menuType
          ? "left-container"
          : "left-container left-container-vertical"
      }>
        <div className="left">
          <div className="nav">
            <Menu
              defaultSelectedKeys={["1"]}
              defaultOpenKeys={["sub1"]}
              mode={this.state.menuType ? "inline" : "vertical"}
              theme="dark"
              inlineCollapsed={this.state.collapsed}
            >
              <SubMenu
                key="1"
                title={
                  <span>
                    <Icon type="mail" />
                    {!!this.state.menuType &&(
                      <span>课程管理</span>
                    )}
                  </span>
                }
              >
                  <Menu.Item key="1-1">
                    <span>直播课</span>
                  </Menu.Item>
                  <Menu.Item key="1-2">
                    <span>视频课</span>
                  </Menu.Item>
              </SubMenu>

              <Menu.Item key="2">
                <Icon type="pie-chart" />
                {!!this.state.menuType &&(
                  <span>资料云盘</span>
                )}
              </Menu.Item>
              <SubMenu
                key="3"
                title={
                  <span>
                    <Icon type="mail" />
                    {!!this.state.menuType &&(
                      <span>课程管理</span>
                    )}
                  </span>
                }
              >
                  <Menu.Item key="3-1">
                    <span>讲师管理</span>
                  </Menu.Item>
                  <Menu.Item key="3-2">
                    <span>用户管理</span>
                  </Menu.Item>
                  <Menu.Item key="3-3">
                    <span>课程分类</span>
                  </Menu.Item>
                  <Menu.Item key="3-4">
                    <span>店铺装修</span>
                  </Menu.Item>
              </SubMenu>
            </Menu>
          </div>
        </div>
        <div></div>
      </div>
    );
  }
}

export default withRouter(Menus);
