/*
 * @Author: 吴文洁
 * @Date: 2019-07-10 10:30:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-09 11:27:58
 * @Description:
 */
import React, { useContext, useEffect, useState } from 'react';
import { withRouter} from 'react-router-dom';
import {ConfigProvider } from 'antd';
import Header from './Header'
import Menu from './Menu'
import Main from './Main'
import zhCN from 'antd/es/locale/zh_CN'
import User from '@/common/js/user';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import { setStoreGroupPermission, setStorePermission, setStoreGroupList, setStoreList } from '@/store/actions/index';
declare var window: any;

const App: React.FC = (props: any) => {
  const ctx: any = useContext(XMContext);
  const userId = User.getUserId();
  window.ctx = ctx;

  useEffect(() => {
    getStoreAndUserInfo();
  },[userId])

  async function getStoreAndUserInfo(){
    await getStoreGroupAndStoreList();
  }

  function getStoreGroupAndStoreList() {
    BaseService.getUserStore({ userId }).then((res) => {
      
      const { storeGroupVOS = [], storeVOS = [] } = res.result;
      const { id, storeUserId,storeName } = storeVOS[0];

      User.setStoreId(id);
      User.setStoreUserId(storeUserId);
      User.setStoreName(storeName);
      ctx.dispatch(setStoreGroupList(storeGroupVOS))
      ctx.dispatch(setStoreList(storeVOS));
      
      getUserPermission();
    });
  }

  function getUserPermission() {
    BaseService.getUserPermission({  }).then((res) => {
      console.log(res.result);
      const {storePermission, storePermissionGroup, storeUserPermission, storeUserPermissionGroup } = res.result;
      ctx.dispatch(setStoreGroupPermission(storePermissionGroup))
      ctx.dispatch(setStorePermission(storeUserPermissionGroup))
    });
  }

    return (
      <div id="home">
        <Header/>
        <ConfigProvider locale={zhCN} >
          <Main/>
        </ConfigProvider>
        <Menu/>
      </div>
    )
}

export default withRouter(App)
