/*
 * @Author: 吴文洁 
 * @Date: 2020-07-20 19:12:49 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-20 20:25:13
 * @Description: 大班直播分享弹窗
 */

import React from 'react';
import { Modal, Input, Button, message } from 'antd';
import domtoimage from 'dom-to-image';
import html2canvas from 'html2canvas';
import qrcode from "@/libs/qrcode/qrcode.js";



import './ShareLiveModal.less';

const BASE_IMG = require('@/images/xiaomai-IMG.png');
const { name, banner = BASE_IMG } = currentUserInstInfo;
const DEFAULT_COVER = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';

class ShareLiveModal extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      shareUrl: 'https://xiaomai5.com/liveShare?courseId=12'
    }
  }

  componentDidMount() {
    // 获取短链接
    this.handleConvertShortUrl();
  }

  handleConvertShortUrl = () => {
    const { longUrl } = this.props.data;

    // 发请求
    axios.Sales('public/businessShow/convertShortUrls', {
      urls: [longUrl]
    }).then((res) => {
      const { result = [] } = res;
      this.setState({
        shareUrl: result[0].shortUrl
      }, () => { 
        const qrcodeWrapDom = document.querySelector('#qrcodeWrap');
        const qrcodeNode = new qrcode({
          text: this.state.shareUrl,
          size: 98,
        })
        qrcodeWrapDom.appendChild(qrcodeNode);
      });
    })
  }

  componentWillUnmount() {
    // 页面销毁之前清空定时器
    clearTimeout(this.timer);
  }

  // 下载海报
  handleDownloadPoster = () => {
    const dom = document.querySelector('#poster');
    html2canvas(dom, {
      useCORS: true,
    }).then(canvas => {
      const download = document.createElement('a');
      const { courseName } = this.props.data;
      const dataUrl = canvas.toDataURL('image/png');
      $(download).attr('href', dataUrl).attr('download', `${courseName}.png`).get(0).click();
    })
  }
  
  // 复制分享链接
  handleCopy = () => {
    const textContent = document.getElementById('shareUrl').innerText;

    window.copyText(textContent);
    message.success('复制成功!');
  }
  
  render() {
    const { needStr, data, type } = this.props;
    const { courseName, coverUrl = DEFAULT_COVER, scheduleVideoUrl } = data;
    const { shareUrl } = this.state;

    // 判断是否是默认图, 默认图不需要在URL后面增加字符串
    const isDefaultCover = coverUrl === DEFAULT_COVER;

    const coverImgSrc = type === 'videoClass'
      // 如果是默认图, 显示视频的第一帧, 否则显示上传的视频封面
      ? ((!coverUrl || isDefaultCover)
        ? `${scheduleVideoUrl}?x-oss-process=video/snapshot,t_0,m_fast&anystring=anystring`
        : `${coverUrl}${!needStr ? '&anystring=anystring': ''}`)
      : `${coverUrl}${(!needStr && !isDefaultCover) ? '&anystring=anystring' : ''}`

    return (

      <Modal
        title={type === 'videoClass' ? '分享视频课' : '分享直播课'}
        width={680}
        visible={true}
        footer={null}
        className="share-live-modal"
        onCancel={this.props.close}
      >
        <div className="left" id="poster">
        
          <div className="course-name">{`【${courseName}】开课啦，快来学习！`}</div>
          <img
            src={coverImgSrc}
            crossOrigin="*"
            className="course-cover"
          />

          <div className="qrcode-wrap">
            <div className="qrcode-wrap__left">
              <div className="text">长按识别二维码进入观看</div>
              <img className="finger" src="https://image.xiaomaiketang.com/xm/thpkWDwJsC.png"/>
            </div>
            <div className="qrcode-wrap__right" id="qrcodeWrap">
            </div>
          </div>
          
          <div className="inst-name">
            <span className="icon iconfont">&#xe7b1;</span>
            <span className="text">{name}</span>
          </div>
        </div>
        <div className="right">
          <div className="share-url right__item">
            <div className="title">① 链接分享</div>
            <div className="sub-title">学生可通过微信打开链接，报名观看直播</div>
            <div className="content">
              <div className="share-url" id="shareUrl">{shareUrl}</div>
              <Button type="primary" onClick={this.handleCopy}>复制</Button>
            </div>
          </div>

           <div className="share-poster right__item">
            <div className="title">② 海报分享</div>
            <div className="sub-title">学生可通过微信识别二维码，报名观看直播</div>
            <div className="content" onClick={this.handleDownloadPoster}>下载海报</div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default ShareLiveModal;
