import React, { useState, useEffect } from "react";
import "./LeftStageList.less";
import ENUM from "../../enum";

function LeftStageList(props) {
  const { stageExamList, activeExam, activeStage } = props;
  const [stageList, setStageList] = useState(stageExamList || []);

  // 展开和收起阶段下面的考试
  function handleToggleExpand(stageIndex) {
    let _taskList = [...stageList];
    _taskList = _taskList.map((item, index) => {
      if (stageIndex === index) {
        item.isShowMoreCourse = !item.isShowMoreCourse;
      }
      return item;
    });
    setStageList(_taskList || []);
  }

  return (
    <div className="left-stage-list">
      {stageList.map((item, index) => {
        return (
          <div key={index} className="stage-list">
            <div
              className={`stage-item ${
                item.stageId === activeStage.stageId ? "active" : ""
              }`}
              onClick={() => handleToggleExpand(index)}
            >
              <div className="icon">
                {item.isShowMoreCourse ? (
              <span className="icon iconfont edit-icon">&#xe677;</span>
                ) : (
                  <span className="icon iconfont edit-icon">&#xe600;</span>
                )}
              </div>
              <div className="stage-name">
                {ENUM.IndexToSort[index + 1]}、{item.stageName}
              </div>
            </div>
            {!item.isShowMoreCourse && (
              <div className="exam-list">
                {item.contentVOList && item.contentVOList.map((examItem, examIdndex) => {
                  return (
                    <div
                      key={examIdndex}
                      className={`exam-item ${
                        examItem.contentId === activeExam.contentId ? "active" : ""
                      }`}
                      onClick={()=>{
                          props.changeActiveExam(examItem,item)
                      }}
                    >
                      <div className="exam-name">
                        {item.sequence}.{examItem.sequence}{' '}{examItem.contentName}
                        
                      </div>
                    </div>
                  );
                })}
              </div>
            )}
          </div>
        );
      })}
    </div>
  );
}

export default LeftStageList;
