/*
 * @Description: 直播开始上课之前对余额的校验
 * @Author: zhangyi
 * @Date: 2020-05-18 13:47:42
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-09 16:36:33
 */
import React from 'react';
import { Modal, Button } from "antd";
import AccountChargeModal from "./AccountChargeModal";

const textStyle = {
  lineHeight: "20px",
  fontSize: "14px",
  color: "#666666",
};

class CheckBalanceModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }
  componentDidMount() {}
  handleReCharge = () => {
    const chargeModal = (
      <AccountChargeModal
        close={() => {
          this.setState({
            chargeModal: null,
          });
        }}
        refresh={() => {
          this.props.close();
        }}
      />
    );
    this.setState({
      chargeModal,
    });
  };
  render() {
    const { balance, currentClass, undoClass } = this.props;
    return (
      <Modal
        visible={true}
        footer={null}
        width={550}
        title="余额不足"
        onCancel={() => {
          this.props.close();
        }}
      >
        <div>
          <div style={textStyle} className="mb8">
            本次直播您将扣除{currentClass.toFixed(2)}元费用，预计当前账户余额不足抵扣本次课次及其他结算课次费用，请您尽快充值。
          </div>
          <div style={textStyle}>
            当前余额：
            <span style={{ color: "#EC4B35" }}>{balance.toFixed(2)}</span> 元
          </div>
          <div style={textStyle}>
            本课次预估消费：<span>{currentClass.toFixed(2)}</span>元
          </div>
          <div style={textStyle}>
            其他未结算课次预估消费：<span>{undoClass.toFixed(2)}</span>元
          </div>
          <div style={{ textAlign: "center", marginTop: 25 }}>
            <Button
              style={{
                width:136,
                height:'40px',
                lineHeight: '40px',
                borderRadius:'4px'
              }}
              type="primary"
              onClick={() => {
                this.handleReCharge();
              }}
            >
              立即充值
            </Button>
          </div>
        </div>
        {this.state.chargeModal}
      </Modal>
    );
  }
}
export default CheckBalanceModal;
