import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { Tabs } from 'antd';
import Service from '@/common/js/service';
import Breadcrumbs from "@/components/Breadcrumbs";
import DataInfo from './components/DataInfo'
import CourseTable from './components/CourseTable';
import ExamTable from './components/ExamTable';
import StudyTable from './components/StudyTable';
import './index.less'
const { TabPane } = Tabs;

function DataCenter(props: any) {
    const { match: { params: { taskId } } } = props;
    const [info, setInfo] = useState<any>({})
    const [tabKey, setTabKey] = useState<any>('')


    const tabList = [
        {
            name: '课程目录',
            key: 'course',
            compoment: CourseTable,
        },
        {
            name: '学习详情',
            key: 'study',
            compoment: StudyTable,
        },
        {
            name: '考试详情',
            key: 'exam',
            compoment: ExamTable,
        },

    ]

    useEffect(() => {
        getInfo()
    }, [])

    function getInfo() {
        Service.Hades('/public/hades/getTrainingTaskDetail', { taskId }).then((res: any) => {
            res.result.trainingStageList.map((item: any) => {
                item.open = true
            })
            res.result.cover =res.result.courseMediaVOS.filter((item:any) => item.contentType === 'COVER')[0]
            setInfo(res.result)
        })
    }

    return <div className="page train-data-center">
        <Breadcrumbs
            navList="培训任务详情"
            goBack={() => {
                props.history.goBack();
            }}
        />
        <div className="content">
            <DataInfo info={info} />
            <Tabs defaultActiveKey={'course'} onChange={() => { }}>
                {
                    tabList.map((item: any) => {
                        return <TabPane tab={item.name} key={item.key}>
                            {
                                <item.compoment info={info} />
                            }
                        </TabPane>
                    })
                }

            </Tabs>
        </div>

    </div>
}

export default withRouter(DataCenter)
