/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-13 09:54:26
 * @LastEditors: fusanqiasng
 * @LastEditTime: 2021-05-28 15:35:33
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React from 'react'
import { Row, Modal, Button, message, Radio, Table, Input, Tabs, Tooltip, TreeSelect } from 'antd'
import { PageControl } from '@/components'
import TableSelectedData from '@/components/TableSelectedData'
import KnowledgeAPI from '@/data-source/knowledge/request-api'
import AidToolService from '@/domains/aid-tool-domain/AidToolService'
import User from '@/common/js/user'
import './LiveList.less'

import _ from 'underscore'
import dealTimeDuration from '../../course-manage/utils/dealTimeDuration'

const { Search } = Input
const { TabPane } = Tabs
const courseStateShow = {
  UN_START: {
    code: 1,
    title: '待开课',
    color: '#2966FF',
  },
  STARTING: {
    code: 2,
    title: '上课中',
    color: '#238FFF',
  },
  FINISH: {
    code: 3,
    title: '已完成',
    color: '#3BBDAA',
  },
  EXPIRED: {
    code: 4,
    title: '未成功开课',
    color: '#999',
  },
}

class AddCourse extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      liveDataSource: [],
      liveSize: 10,
      liveQuery: {
        current: 1,
        excludeUsed: true,
        courseType: 'LIVE',
        storeId: User.getStoreId(),
        toRefKnowledgeCategoryId: this.props.categoryId,
      },
      liveTotalCount: 0,
      selectLive: [], //弹窗内已选择的直播课程

      videoCourseDivision: 'internal',
      videoDataSource: {
        external: [],
        internal: [],
      },
      videoSize: {
        external: 10,
        internal: 10,
      },
      videoSearchDefalt: {
        external: {
          categoryId: '',
          courseName: '',
        },
        internal: {
          categoryId: '',
          courseName: '',
        },
      },

      videoQuery: {
        external: {
          categoryId: '',
          courseName: '',
          current: 1,
          courseType: 'VOICE',
          excludeUsed: true,
          storeId: User.getStoreId(),
          toRefKnowledgeCategoryId: this.props.categoryId,
        },
        internal: {
          categoryId: '',
          courseName: '',
          current: 1,
          courseType: 'VOICE',
          excludeUsed: true,
          storeId: User.getStoreId(),
          toRefKnowledgeCategoryId: this.props.categoryId,
        },
      },
      videoTotalCount: {
        external: 0,
        internal: 0,
      },
      selectVideo: {
        external: [],
        internal: [],
      }, //弹窗内已选择的视频课程
      currentVideoCourseListData: {
        external: [],
        internal: [],
      }, //页面中已关联的视频课程

      pictureDataSource: [],
      pictureSize: 10,
      pictureQuery: {
        current: 1,
        excludeUsed: true,
        courseType: 'PICTURE',
        storeId: User.getStoreId(),
        toRefKnowledgeCategoryId: this.props.categoryId,
      },
      pictureTotalCount: 0,
      selectPicture: [], //弹窗内已选择的图文课程
      categoryList: [], //内部分类列表
      categoryListExternal: [], //外部分类列表
    }
  }
  componentDidMount() {
    this.handleFetchLiveList()
    this.handleFetchVideoList()
    this.handleFetchPictureList()
    this.queryCategoryTree()
  }

  // 查询分类树
  queryCategoryTree = (categoryName) => {
    let query = {
      storeId: User.getStoreId(),
      withCount: false,
    }
    let queryInternal = {
      bizType: 'QUESTION',
      source: 2,
      tenantId: User.getStoreId(),
      userId: User.getStoreUserId(),
      count: false,
    }
    AidToolService.queryExternalCategoryTree(queryInternal).then((res) => {
      const { categoryList = [] } = res.result
      this.setState({
        categoryListExternal: this.renderTreeNodes(categoryList),
      })
    })
    KnowledgeAPI.getCategoryTree(query).then((res) => {
      const { categoryList = [] } = res.result
      this.setState({
        categoryList: this.renderTreeNodes(categoryList),
      })
    })
  }

  renderTreeNodes = (data) => {
    let newTreeData = data.map((item) => {
      item.title = (
        <span>
          <span className='icon iconfont' style={{ color: '#FBD140' }}>
            &#xe7f1;&nbsp;
          </span>
          {item.categoryName}
        </span>
      )
      item.key = item.id
      if (item.sonCategoryList) {
        item.children = this.renderTreeNodes(item.sonCategoryList)
      }
      return item
    })
    return newTreeData
  }

  // 获取直播课列表
  handleFetchLiveList = () => {
    const { liveQuery, liveSize } = this.state

    const params = {
      ...liveQuery,
      size: liveSize,
    }

    // CourseService.getLiveCloudCoursePage(params).then((res) => {
    KnowledgeAPI.knowledgeLiveCoursePage(params).then((res) => {
      const { result = {} } = res
      const { records = [], total = 0 } = result
      this.setState({
        liveDataSource: records,
        liveTotalCount: Number(total),
      })
    })
  }

  // 获取视频课列表
  handleFetchVideoList = () => {
    const { videoQuery, videoSize, videoCourseDivision, videoDataSource, videoTotalCount } = this.state

    const params = {
      ...videoQuery[videoCourseDivision],
      size: videoSize[videoCourseDivision],
      courseDivision: videoCourseDivision === 'internal' ? 'INTERNAL' : 'EXTERNAL',
    }

    // CourseService.videoSchedulePage(query).then((res) => {
    KnowledgeAPI.knowledgeMediaCoursePage(params).then((res) => {
      const { result = {} } = res || {}
      const { records = [], total = 0 } = result
      this.setState({
        videoDataSource: {
          ...videoDataSource,
          [videoCourseDivision]: records,
        },
        videoTotalCount: {
          ...videoTotalCount,
          [videoCourseDivision]: Number(total),
        },
      })
    })
  }

  // 获取图文课列表
  handleFetchPictureList = () => {
    const { pictureQuery, pictureSize } = this.state

    const params = {
      ...pictureQuery,
      size: pictureSize,
    }

    // CourseService.pictureSchedulePage(query).then((res) => {
    KnowledgeAPI.knowledgeMediaCoursePage(params).then((res) => {
      const { result = {} } = res || {}
      const { records = [], total = 0 } = result
      this.setState({
        pictureDataSource: records,
        pictureTotalCount: Number(total),
      })
    })
  }

  onShowLiveSizeChange = (current, size) => {
    if (current === size) {
      return
    }
    this.setState(
      {
        liveSize: size,
      },
      () => {
        this.handleFetchLiveList()
      }
    )
  }

  onShowVideoSizeChange = (current, size) => {
    if (current === size) {
      return
    }
    this.setState(
      {
        videoSize: size,
      },
      () => {
        this.handleFetchVideoList()
      }
    )
  }

  onShowPictureSizeChange = (current, size) => {
    if (current === size) {
      return
    }
    this.setState(
      {
        pictureSize: size,
      },
      () => {
        this.handleFetchPictureList()
      }
    )
  }

  liveColumns = () => {
    const columns = [
      {
        title: (
          <span>
            <span>课程信息</span>
            <Tooltip title={<div>已加入该分类的课程不支持重复选择，因此不显示。</div>}>
              <i
                className='icon iconfont'
                style={{
                  marginLeft: '5px',
                  cursor: 'pointer',
                  color: '#bfbfbf',
                  fontSize: '14px',
                }}>
                &#xe61d;
              </i>
            </Tooltip>
          </span>
        ),
        width: 371,
        key: 'course',
        dataIndex: 'courseName',
        render: (val, record) => {
          let hasCover = false
          return (
            <div className='record__item'>
              {record.courseMediaVOS.map((item) => {
                if (item.contentType === 'COVER') {
                  hasCover = true
                  return <img className='course-cover' src={item.mediaUrl} alt='' />
                }
              })}
              {!hasCover && <img className='course-cover' src={'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png'} alt='' />}
              <div>
                <Choose>
                  <When condition={record.courseName.length > 17}>
                    <Tooltip title={record.courseName}>
                      <div className='course-name'>{record.courseName}</div>
                    </Tooltip>
                  </When>
                  <Otherwise>
                    <div className='course-name'>{record.courseName}</div>
                  </Otherwise>
                </Choose>
                <div>
                  <span
                    className='course-status'
                    style={{
                      color: courseStateShow[record.courseState].color,
                      border: `1px solid ${courseStateShow[record.courseState].color}`,
                    }}>
                    {courseStateShow[record.courseState].title}
                  </span>
                </div>
              </div>
            </div>
          )
        },
      },
      {
        title: '上课时间',
        width: 110,
        key: 'couseCatalog',
        dataIndex: 'couseCatalog',
        render: (val, item) => {
          return (
            <span className='course-time'>
              {formatDate('YYYY-MM-DD', parseInt(item.startTime))} <br></br>
              {formatDate('H:i', parseInt(item.startTime))}~{formatDate('H:i', parseInt(item.endTime))}
            </span>
          )
        },
      },

      {
        title: '课程分类',
        // width: "10%",
        key: 'couseCatalog',
        dataIndex: 'couseCatalog',
        render: (val, record) => {
          return (
            <div className='categoryName'>
              {record.categoryOneName}
              {record.categoryTwoName ? `-${record.categoryTwoName}` : ''}
            </div>
          )
        },
      },
    ]

    return columns
  }

  videoColumns = () => {
    const { videoCourseDivision } = this.state
    const columns = [
      {
        title: (
          <span>
            <span>课程信息</span>
            <Tooltip title={<div>已加入该分类的课程不支持重复选择，因此不显示。</div>}>
              <i
                className='icon iconfont'
                style={{
                  marginLeft: '5px',
                  cursor: 'pointer',
                  color: '#bfbfbf',
                  fontSize: '14px',
                }}>
                &#xe61d;
              </i>
            </Tooltip>
          </span>
        ),
        key: 'scheduleName',
        dataIndex: 'scheduleName',
        width: 300,
        render: (val, record) => {
          const { coverUrl, mediaCourseUrl } = record
          return (
            <div className='record__item'>
              {/* 上传了封面的话就用上传的封面, 没有的话就取视频的第一帧 */}
              <img
                className='course-cover'
                src={
                  coverUrl ||
                  (videoCourseDivision === 'internal'
                    ? `${mediaCourseUrl}?x-oss-process=video/snapshot,t_0,m_fast`
                    : 'https://image.xiaomaiketang.com/xm/mt3ZQRxGKB.png')
                }
                alt=''
              />
              <Choose>
                <When condition={record.courseName.length > 25}>
                  <Tooltip title={record.courseName}>
                    <div className='course-name'>{record.courseName}</div>
                  </Tooltip>
                </When>
                <Otherwise>
                  <div className='course-name'>{record.courseName}</div>
                </Otherwise>
              </Choose>
            </div>
          )
        },
      },
      {
        title: '课程时长',
        key: 'videoDuration',
        width: 80,
        dataIndex: 'videoDuration',
        render: (text, item) => {
          return <span>{text ? dealTimeDuration(text) : '-'}</span>
        },
      },

      {
        title: '课程分类',
        key: 'categoryName',
        dataIndex: 'categoryName',
        render: (val, record) => {
          return (
            <Choose>
              <When condition={videoCourseDivision === 'internal'}>
                <div className='record__item'>
                  {record.categoryOneName}
                  {record.categoryTwoName ? `-${record.categoryTwoName}` : ''}
                </div>
              </When>
              <Otherwise>
                <div className='record__item'>{record.categorySonName}</div>
              </Otherwise>
            </Choose>
          )
        },
      },
    ]
    return columns
  }

  pictureColumns = () => {
    const columns = [
      {
        title: (
          <span>
            <span>课程信息</span>
            <Tooltip title={<div>已加入该分类的课程不支持重复选择，因此不显示。</div>}>
              <i
                className='icon iconfont'
                style={{
                  marginLeft: '5px',
                  cursor: 'pointer',
                  color: '#bfbfbf',
                  fontSize: '14px',
                }}>
                &#xe61d;
              </i>
            </Tooltip>
          </span>
        ),
        key: 'scheduleName',
        dataIndex: 'scheduleName',
        width: 371,
        render: (val, record) => {
          const { coverUrl } = record
          return (
            <div className='record__item'>
              {/* 上传了封面的话就用上传的封面, 没有的话就取视频的第一帧 */}
              <img className='course-cover' src={coverUrl || 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png'} alt='' />
              <Choose>
                <When condition={record.courseName.length > 25}>
                  <Tooltip title={record.courseName}>
                    <div className='course-name'>{record.courseName}</div>
                  </Tooltip>
                </When>
                <Otherwise>
                  <div className='course-name'>{record.courseName}</div>
                </Otherwise>
              </Choose>
            </div>
          )
        },
      },
      {
        title: '课程分类',
        key: 'categoryName',
        dataIndex: 'categoryName',
        render: (val, record) => {
          return (
            <div className='record__item'>
              {record.categoryOneName}
              {record.categoryTwoName ? `-${record.categoryTwoName}` : ''}
            </div>
          )
        },
      },
    ]
    return columns
  }

  selectLiveList = (record, selected) => {
    let { selectLive } = this.state
    let _list = []
    if (selected || !_.find(selectLive, (item) => item.liveCourseId === record.liveCourseId)) {
      _list = _.uniq(selectLive.concat([record]), false, (item) => item.liveCourseId)
    } else {
      _list = _.reject(selectLive, (item) => item.liveCourseId === record.liveCourseId)
    }
    this.setState({ selectLive: _list })
  }

  selectVideoList = (record, selected) => {
    const { selectVideo, videoCourseDivision } = this.state

    let { [videoCourseDivision]: selectList } = selectVideo

    let _list = []
    if (selected || !_.find(selectList, (item) => item.id === record.id)) {
      _list = _.uniq(selectList.concat([record]), false, (item) => item.id)
    } else {
      _list = _.reject(selectList, (item) => item.id === record.id)
    }

    this.setState({
      selectVideo: {
        ...selectVideo,
        [videoCourseDivision]: _list,
      },
    })
  }

  selectPictureList = (record, selected) => {
    console.log(record)
    let { selectPicture } = this.state
    let _list = []
    if (selected || !_.find(selectPicture, (item) => item.id == record.id)) {
      _list = _.uniq(selectPicture.concat([record]), false, (item) => item.id)
    } else {
      _list = _.reject(selectPicture, (item) => item.id === record.id)
    }
    this.setState({ selectPicture: _list })
  }

  callback(key) {
    console.log(key)
  }

  handleChangVideoFilter = (key, value) => {
    const { videoQuery, videoCourseDivision, videoSearchDefalt } = this.state
    videoQuery[videoCourseDivision][key] = value
    videoSearchDefalt[videoCourseDivision][key] = value
    videoQuery[videoCourseDivision].current = 1
    this.setState(
      {
        videoQuery,
        videoSearchDefalt,
      },
      () => {
        this.handleFetchVideoList()
      }
    )
  }

  handleChangVideoCourseName = (e) => {
    const { videoSearchDefalt, videoCourseDivision } = this.state
    videoSearchDefalt[videoCourseDivision].courseName = e.target.value
    this.setState({
      videoSearchDefalt,
    })
  }

  handleChangLiveFilter = (key, value) => {
    const { liveQuery } = this.state
    liveQuery[key] = value
    liveQuery.current = 1
    this.setState(
      {
        liveQuery,
      },
      () => {
        this.handleFetchLiveList()
      }
    )
  }

  handleChangPictureFilter = (key, value) => {
    const { pictureQuery } = this.state
    pictureQuery[key] = value
    pictureQuery.current = 1
    this.setState(
      {
        pictureQuery,
      },
      () => {
        this.handleFetchPictureList()
      }
    )
  }
  handAddCourse = () => {
    const { selectVideo, selectLive, selectPicture } = this.state
    const batchAddList = []
    if (selectVideo.external.length) {
      batchAddList.push({
        categoryId: this.props.categoryId,
        refIds: _.pluck(selectVideo.external, 'id'),
        storeId: User.getStoreId(),
        type: 'VOICE',
        createId: User.getStoreUserId(),
      })
    }
    if (selectVideo.internal.length) {
      batchAddList.push({
        categoryId: this.props.categoryId,
        refIds: _.pluck(selectVideo.internal, 'id'),
        storeId: User.getStoreId(),
        type: 'VOICE',
        createId: User.getStoreUserId(),
      })
    }
    if (selectLive.length) {
      batchAddList.push({
        categoryId: this.props.categoryId,
        refIds: _.pluck(selectLive, 'liveCourseId'),
        storeId: User.getStoreId(),
        type: 'LIVE',
        createId: User.getStoreUserId(),
      })
    }
    if (selectPicture.length) {
      batchAddList.push({
        categoryId: this.props.categoryId,
        refIds: _.pluck(selectPicture, 'id'),
        storeId: User.getStoreId(),
        type: 'PICTURE',
        createId: User.getStoreUserId(),
      })
    }

    KnowledgeAPI.addDifTypeKnowledge({ batchAddList }).then(({ success }) => {
      if (success) {
        message.success('新增成功')
        this.props.onClose()
        this.props.onChange()
        this.props.updateCategoryTree()
      }
    })
  }
  videoCourseDivisionChange = (e) => {
    const { videoQuery, videoSearchDefalt } = this.state
    this.setState(
      {
        videoCourseDivision: e.target.value,
        videoSearchDefalt: {
          ...videoSearchDefalt,
          [e.target.value]: {
            courseName: videoQuery[e.target.value].courseName,
            categoryId: videoQuery[e.target.value].categoryId,
          },
        },
      },
      () => {
        this.handleFetchVideoList()
      }
    )
  }

  renderFooter = () => {
    const { selectVideo, selectPicture, selectLive } = this.state
    return (
      <div>
        <Button onClick={this.props.onClose}>取消</Button>
        <Button
          disabled={!(selectLive.length || selectVideo.external.length || selectVideo.internal.length || selectPicture.length)}
          type='primary'
          onClick={this.handAddCourse}>
          确定
        </Button>
      </div>
    )
  }

  render() {
    const {
      liveDataSource,
      liveSize,
      liveQuery,
      liveTotalCount,
      selectLive,
      videoDataSource,
      videoSize,
      videoQuery,
      videoTotalCount,
      videoCourseDivision,
      selectVideo,
      pictureDataSource,
      pictureSize,
      pictureQuery,
      pictureTotalCount,
      selectPicture,
      videoSearchDefalt,
      categoryList,
      categoryListExternal,
    } = this.state

    const LiveSelection = {
      selectedRowKeys: _.pluck(selectLive, 'liveCourseId'),
      onSelect: this.selectLiveList,
      onSelectAll: (selected, _selectedRows, changeRows) => {
        let _list = []
        if (selected) {
          _list = _.uniq(selectLive.concat(changeRows), false, (item) => item.liveCourseId)
        } else {
          _list = _.reject(selectLive, (item) => _.find(changeRows, (data) => data.liveCourseId === item.liveCourseId))
        }
        this.setState({ selectLive: _list })
      },
    }

    const VideoSelection = {
      selectedRowKeys: _.pluck(selectVideo[videoCourseDivision], 'id'),
      onSelect: this.selectVideoList,
      onSelectAll: (selected, _selectedRows, changeRows) => {
        let _list = []
        if (selected) {
          _list = _.uniq(selectVideo[videoCourseDivision].concat(changeRows), false, (item) => item.id)
        } else {
          _list = _.reject(selectVideo[videoCourseDivision], (item) => _.find(changeRows, (data) => data.id === item.id))
        }
        this.setState({
          selectVideo: {
            ...selectVideo,
            [videoCourseDivision]: _list,
          },
        })
      },
    }

    const PictureSelection = {
      selectedRowKeys: _.pluck(selectPicture, 'id'),
      onSelect: this.selectPictureList,
      onSelectAll: (selected, _selectedRows, changeRows) => {
        let _list = []
        if (selected) {
          _list = _.uniq(selectPicture.concat(changeRows), false, (item) => item.id)
        } else {
          _list = _.reject(selectPicture, (item) => _.find(changeRows, (data) => data.id === item.id))
        }
        this.setState({ selectPicture: _list })
      },
    }

    return (
      <Modal visible={true} width={800} title='新增课程' footer={this.renderFooter()} onCancel={this.props.onClose} className='add-course-modal'>
        <Tabs defaultActiveKey='LIVE'>
          <TabPane tab='直播课' key='LIVE'>
            <div className='live-list'>
              <div>
                <Row type='flex' justify='space-between' align='top'>
                  <div>
                    <span style={{ lineHeight: '32px' }}>课程名称：</span>
                    <Search
                      style={{ width: 'calc(100% - 75px)' }}
                      placeholder='搜索课程名称'
                      onSearch={(value) => {
                        this.handleChangLiveFilter('courseName', value)
                      }}
                      enterButton={<span className='icon iconfont'>&#xe832;</span>}
                    />
                  </div>
                  <div style={{ width: '50%' }}>
                    <span className='shelf-status'>课程分类：</span>
                    <TreeSelect
                      treeNodeFilterProp='categoryName'
                      showSearch
                      style={{ width: 'calc(100% - 75px)' }}
                      dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
                      treeData={categoryList}
                      placeholder='请选择课程类型'
                      allowClear
                      onChange={(value) => {
                        this.handleChangLiveFilter('categoryId', value)
                      }}
                    />
                  </div>
                </Row>
              </div>
              <TableSelectedData
                selectedNum={selectVideo.internal.length + selectVideo.external.length + selectLive.length + selectPicture.length}
                clearSelectedData={() => {
                  this.setState({
                    selectVideo: {
                      internal: [],
                      external: [],
                    },
                    selectLive: [],
                    selectPicture: [],
                  })
                }}
              />
              <Table
                bordered
                size='middle'
                pagination={false}
                columns={this.liveColumns()}
                rowSelection={LiveSelection}
                // loading={loading}
                dataSource={liveDataSource}
                style={{ maxHeight: 359, overflow: 'scroll' }}
                rowKey={(row) => row.liveCourseId}
              />
              {liveTotalCount > 0 && (
                <div className='box-footer'>
                  <PageControl
                    current={liveQuery.current - 1}
                    pageSize={liveSize}
                    total={parseInt(liveTotalCount)}
                    toPage={(page) => {
                      const _query = { ...liveQuery, current: page + 1 }
                      this.setState(
                        {
                          liveQuery: _query,
                        },
                        () => {
                          this.handleFetchLiveList()
                        }
                      )
                    }}
                    onShowSizeChange={this.onShowLiveSizeChange}
                  />
                </div>
              )}
            </div>
          </TabPane>
          <TabPane tab='视频课' key='VIDEO'>
            <Radio.Group value={videoCourseDivision} onChange={this.videoCourseDivisionChange} style={{ marginBottom: 8 }}>
              <Radio.Button value='internal'>内部课程</Radio.Button>
              <Radio.Button value='external'>外部课程</Radio.Button>
            </Radio.Group>
            <div className='live-list'>
              <div>
                <Row type='flex' justify='space-between' align='top'>
                  <div>
                    <span style={{ lineHeight: '32px' }}>课程名称：</span>
                    <Search
                      value={videoSearchDefalt[videoCourseDivision].courseName}
                      style={{ width: 'calc(100% - 75px)' }}
                      placeholder='搜索课程名称'
                      onChange={this.handleChangVideoCourseName}
                      onSearch={(value) => {
                        this.handleChangVideoFilter('courseName', value)
                      }}
                      enterButton={<span className='icon iconfont'>&#xe832;</span>}
                    />
                  </div>
                  <div style={{ width: '50%' }}>
                    <span className='shelf-status'>课程分类：</span>
                    <TreeSelect
                      treeNodeFilterProp='categoryName'
                      showSearch
                      style={{ width: 'calc(100% - 75px)' }}
                      dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
                      treeData={videoCourseDivision === 'internal' ? categoryList : categoryListExternal}
                      placeholder='请选择课程类型'
                      allowClear
                      onChange={(value) => {
                        this.handleChangVideoFilter('categoryId', value)
                      }}
                    />
                  </div>
                </Row>
              </div>
              <TableSelectedData
                selectedNum={selectVideo.internal.length + selectVideo.external.length + selectLive.length + selectPicture.length}
                clearSelectedData={() => {
                  this.setState({
                    selectVideo: {
                      internal: [],
                      external: [],
                    },
                    selectLive: [],
                    selectPicture: [],
                  })
                }}
              />
              <Table
                rowKey={(record) => record.id}
                dataSource={videoDataSource[videoCourseDivision]}
                columns={this.videoColumns()}
                size='middle'
                rowSelection={VideoSelection}
                pagination={false}
                bordered
                className='video-list-table'
                style={{ maxHeight: 359, overflow: 'scroll' }}
              />

              <div className='box-footer'>
                {videoDataSource[videoCourseDivision].length > 0 && (
                  <PageControl
                    current={videoQuery[videoCourseDivision].current - 1}
                    pageSize={videoSize[videoCourseDivision]}
                    total={videoTotalCount[videoCourseDivision]}
                    toPage={(page) => {
                      const _query = { ...videoQuery[videoCourseDivision], current: page + 1 }
                      console.log('_query', _query)
                      this.setState(
                        {
                          videoQuery: {
                            ...videoQuery,
                            [videoCourseDivision]: _query,
                          },
                        },
                        () => {
                          this.handleFetchVideoList()
                        }
                      )
                    }}
                    onShowSizeChange={this.onShowVideoSizeChange}
                  />
                )}
              </div>
            </div>
          </TabPane>

          <TabPane tab='图文课' key='PICTURE'>
            <div className='live-list'>
              <div>
                <Row type='flex' justify='space-between' align='top'>
                  <div>
                    <span style={{ lineHeight: '32px' }}>课程名称：</span>
                    <Search
                      style={{ width: 'calc(100% - 75px)' }}
                      placeholder='搜索课程名称'
                      onSearch={(value) => {
                        this.handleChangPictureFilter('courseName', value)
                      }}
                      enterButton={<span className='icon iconfont'>&#xe832;</span>}
                    />
                  </div>
                  <div style={{ width: '50%' }}>
                    <span className='shelf-status'>课程分类：</span>
                    <TreeSelect
                      treeNodeFilterProp='categoryName'
                      showSearch
                      style={{ width: 'calc(100% - 75px)' }}
                      dropdownStyle={{ maxHeight: 400, overflow: 'auto' }}
                      treeData={categoryList}
                      placeholder='请选择课程类型'
                      allowClear
                      onChange={(value) => {
                        this.handleChangPictureFilter('categoryId', value)
                      }}
                    />
                  </div>
                </Row>
              </div>
              <TableSelectedData
                selectedNum={selectVideo.internal.length + selectVideo.external.length + selectLive.length + selectPicture.length}
                clearSelectedData={() => {
                  this.setState({
                    selectVideo: {
                      internal: [],
                      external: [],
                    },
                    selectLive: [],
                    selectPicture: [],
                  })
                }}
              />
              <Table
                bordered
                size='middle'
                pagination={false}
                columns={this.pictureColumns()}
                rowSelection={PictureSelection}
                // loading={loading}
                dataSource={pictureDataSource}
                style={{ maxHeight: 359, overflow: 'scroll' }}
                rowKey={(row) => row.id}
              />
              {pictureTotalCount > 0 && (
                <div className='box-footer'>
                  <PageControl
                    current={pictureQuery.current - 1}
                    pageSize={pictureSize}
                    total={parseInt(pictureTotalCount)}
                    toPage={(page) => {
                      const _query = { ...pictureQuery, current: page + 1 }
                      this.setState(
                        {
                          pictureQuery: _query,
                        },
                        () => {
                          this.handleFetchPictureList()
                        }
                      )
                    }}
                    onShowSizeChange={this.onShowPictureSizeChange}
                  />
                </div>
              )}
            </div>
          </TabPane>
        </Tabs>
      </Modal>
    )
  }
}
export default AddCourse
