import React, { useState, useEffect } from 'react';
import Breadcrumbs from '@/components/Breadcrumbs';
import WechatUserAuditFilter from './WechatUserAuditFilter';
import WechatUserAuditOpt from './WechatUserAuditOpt'
import WechatUserAuditList from './WechatUserAuditList';
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user';

import './WechatUserAudit.less';
const WechatUserAudit = function () {
  const [listData, setListData] = useState([]);
  const [totalCount, setTotalCount] = useState(0);
  const [query, setQuery] = useState({
    current: 1,
    size: 10,
    applyStatus: 'WAIT'  //PASSED, WAIT, REJECTED 
  });

  useEffect(() => {
    
    //列表获取
    function handleFetchPlanList(_query) {
      const params = {
        ...query,
        ..._query,
        storeId: User.getStoreId(),
      };
    
      StoreService.getCustomerAuditList(params).then((res) => {
        const {
          result: { records = [], total },
        } = res;
        setListData(records);
        setTotalCount(total);
      });
    }
    handleFetchPlanList();
  }, [query]);

  //搜索条件改变
  function queryChange(_query) {
    const params = {
      ...query,
      ..._query,
    };
    setQuery(params);
  }

  return (
    <div className='page wechat-user-audit'>
      <Breadcrumbs navList='学员审核列表' />
      <div className='box'>
        <WechatUserAuditFilter onChange={queryChange} />
        <WechatUserAuditOpt onChange = {queryChange} defaultType={query.applyStatus}/>
       <WechatUserAuditList listData={listData} query={query} totalCount={totalCount} onChange={queryChange} />
      </div>
    </div>
  );
};
export default WechatUserAudit;
