import React from 'react';
import { Row, Radio } from 'antd';
const WechatUserAuditOpt = function (props) {
  const { onChange = () => {}, defaultType = '' } = props;

  return (
    <div className='wechat-user-audit-filter'>
      <Row type='flex' justify='end' align='top'>
        <Radio.Group onChange={(e)=>onChange({applyStatus:e.target.value})} defaultValue={defaultType}>
          <Radio.Button value=''>全部</Radio.Button>
          <Radio.Button value='WAIT'>待审核</Radio.Button>
          <Radio.Button value='PASSED'>已通过</Radio.Button>
          <Radio.Button value='REJECTED'>已拒绝</Radio.Button>
        </Radio.Group>
      </Row>
    </div>
  );
};
export default WechatUserAuditOpt;
