import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Tree, Input, Dropdown, Menu } from "antd";
import "./LeftStructureTree.less";

const { Search } = Input;
const { DirectoryTree } = Tree;

function LeftStructureTree(props) {
  const {treeType} = props
  const treeData = [
    {
      title: "parent 1",
      key: "0-0",
      children: [
        {
          title: "parent 1-0",
          key: "0-0-0",
          children: [
            {
              title: "leaf",
              key: "0-0-0-0",
              disableCheckbox: true,
            },
            {
              title: "leaf",
              key: "0-0-0-1",
            },
          ],
        },
        {
          title: "parent 1-1",
          key: "0-0-1",
          children: [
            {
              title:'aaa',
              key: "0-0-1-0",
            },
          ],
        },
      ],
    },
  ];
  const leftBoxWidth =
    (document.getElementById("left-box") &&
      document.getElementById("left-box").style.width) ||
    "304px";

  const moreOpenGroupOperate = (record) => (
    <Menu>
      <Menu.Item key="edit">
        <span onClick={()=>{props.editPostGroup(record)}}>编辑</span>
      </Menu.Item>
      <Menu.Item key="add" >

        <span onClick={()=>{props.addPostGroup()}}>
          {props.treeType==='postGrouptab' &&
            <span>新建岗位</span>
          }
          {props.treeType==='customGroupTab' &&
            <span>新建分组</span>
          }
        </span>
      </Menu.Item>
      <Menu.Item key="del">
        <span onClick={()=>{props.delPostGroup(record)}}>删除</span>
      </Menu.Item>
    </Menu>
  );


  return (
    <div className="left-structure-tree">
      <div className="tree-con">
        <DirectoryTree
          defaultExpandAll
          showIcon={false}
          treeData={treeData}
          titleRender={(nodeData) => {
            return (
              <div
                className="node-title-div"
                onMouseOver={(e) => {
                  if (nodeData.key === "null") return;
                  let moreDiv = e.currentTarget.getElementsByClassName(
                    "item-more"
                  )[0];
                  let countDiv = e.currentTarget.getElementsByClassName(
                    "item-count"
                  )[0];
                  if (moreDiv) {
                    moreDiv.style.visibility = "visible";
                  }
                  if (countDiv) {
                    countDiv.style.visibility = "hidden";
                  }
                }}
                onMouseOut={(e) => {
                  if (nodeData.key === "null") return;
                  let moreDiv = e.currentTarget.getElementsByClassName(
                    "item-more"
                  )[0];
                  let countDiv = e.currentTarget.getElementsByClassName(
                    "item-count"
                  )[0];
                  if (moreDiv) {
                    moreDiv.style.visibility = "hidden";
                  }
                  if (countDiv) {
                    countDiv.style.visibility = "visible";
                  }
                }}
              >
                <div className="item-icon">
                  <img src="https://image.xiaomaiketang.com/xm/iY4zdsEJb2.png" />
                </div>
                <div
                  className="item-title"
                  style={{
                    width:
                      leftBoxWidth <= "240px"
                        ? "35%"
                        : leftBoxWidth <= "304px"
                        ? "60%"
                        : "78%",
                  }}
                >
                  {nodeData.title}
                </div>
                <div className="item-count">（0）</div>
              
                  { (treeType==='postGrouptab' || treeType=== 'customGroupTab') && (
                    <Dropdown overlay={moreOpenGroupOperate(nodeData)}>
                      <div className="item-more icon iconfont">&#xe927;</div>
                    </Dropdown>
                  )}
                
              </div>
            );
          }}
        />
      </div>
    </div>
  );
}

export default withRouter(LeftStructureTree);
