import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Tree} from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user'
import "./MemberTree.less";

const { DirectoryTree } = Tree;

function MemberTree(props) {
  const {treeType} = props;
  const {treeData,setTreeData}=useState([]);
  useEffect(()=>{
    getTreeData();
  },[]);
  function getTreeData(){
    const params = {
      depType:'DEP_CHAT',
      enterpriseId:User.getEnterpriseId(),
      source:0,//0代表来自企培
      storeId:User.getStoreId(),
      userId:User.getUserId(),
    }
    StoreService.getDepartmentUser(params).then(() => {
      const { departmentVOList=[]} = res.result;
      const _treeData = handleData(departmentVOList);
    });
  }
  function handleData(dataArray){
    dataArray.map((item,index)=>{
      item.key=item.id;
      if(item.sonDepartmentVOList){
        item.children = item.sonDepartmentVOList;
        handleData(item.sonDepartmentVOList)
      }
      return item
    })
  }
  function treeSelected (selectedKeys,e){
    const _checkedNodes = e.checkedNodes;
    const _selectNodes =  _checkedNodes.map((item,index)=>{
      if(item.userType==='VISIBLE_USER'){
       return item;
      }
    })
    props.onSelect(_selectNodes);
  }
  return (
    <div className="member-tree">
      <div className="tree-con">
        <DirectoryTree
          defaultExpandAll
          checkable
          showIcon={false}
          treeData={treeData}
          onCheck={(selectedKeys,e)=>treeSelected(selectedKeys,e)}
          titleRender={(nodeData) => {
            return (
              <div
                className="node-title-con"
              >
                <span className="icon iconfont title-icon">&#xe603;</span>
                <span>{nodeData.title}</span>
              </div>
            );
          }}
        />
      </div>
    </div>
  );
}

export default withRouter(MemberTree);
