import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Button, Input, message,Modal} from "antd";
import LeftStructureTree from "./LeftStructureTree";
import AddOrEditPostGroupModal from "../modal/AddOrEditPostGroupModal";
import UserTable from "./UserTable";

import "./PostGroupTabCon.less";
const { Search } = Input;
function PostGroupTabCon() {
  const [addOrEditPostGroupShow, setAddOrEditPostGroupShow] = useState(false);
  const [postGroupModalType, setPostGroupModalType] = useState(""); // 初始化弹框类型为岗位组
  const [operatePostGroupModalType,setOperatePostGroupModalType] = useState("");  // 初始化弹框操作为添加操作
  const [postGroupModalTitle,setPostGroupModalTitle] = useState("");
  const [postGroupModalLable,setPostGroupModalLable] = useState("");
  const [postGroupName, setPostGroupName] = useState("");
  const [postGroupTreeData, setPostGroupTreeData] = useState([]);
  
  function closeAddOrEditPostGroupModal() {
    setAddOrEditPostGroupShow(false);
  }

  //添加岗位组/岗位
  function addPostGroup(type) {
    if (postGroupTreeData.length === 10) {
      message.error("岗位组数量已达10个上限");
      return;
    }
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("add");
    if(type==='postGroup'){
      setPostGroupModalType('parentGroup'); //parentGroup 代表岗位组
      setPostGroupModalTitle('添加岗位组');
      setPostGroupModalLable('岗位组');
    }else{
      setPostGroupModalType('sub');
      setPostGroupModalTitle('添加岗位'); // sub代表岗位
      setPostGroupModalLable('岗位');
    }
  }

  //编辑岗位组/岗位
  function editPostGroup(record){
    setAddOrEditPostGroupShow(true);
    setOperatePostGroupModalType("edit");
   //level为0的时候编辑的是岗位组 大于0的时候
   if(record.level===0){
    setPostGroupModalType('parentGroup');
    setPostGroupModalTitle('编辑岗位组');
    setPostGroupModalLable('岗位组');
   }else{
    setPostGroupModalType('sub');
    setPostGroupModalTitle('编辑岗位');
    setPostGroupModalLable('岗位');
   }
  }

  function delPostGroup(record){
   let title = '确认删除该岗位组吗？';
   let content= '删除后，该岗位组下的岗位及也将全部删除。';
  
   if(record.level>0){
     title = '确认删除该岗位吗？';
     content = '删除后，不可恢复';
   }
    Modal.confirm({
      title,
      content,
      icon: <span className='icon iconfont default-confirm-icon'>&#xe6f4;</span>,
      okText: '确定',
      okType: 'danger',
      cancelText: '取消',
      onOk: () => {
        
      },
    });
  }

  function getPostGroupTreeData(){  

  }
  function confirmAddOrEditPostGroup() {
     getPostGroupTreeData()
  }
  
  return (
    <div className="post-group-tab-con">
      <div className="organization">
        <div className="search-con">
          <Search
            placeholder="搜索部门/学员姓名"
            className="search search-input"
            style={{ width: 245 }}
            enterButton={<span className="icon iconfont">&#xe832;</span>}
          />
        </div>
        <div className="operate">
          <Button
            className="add-btn"
            onClick={() => {
              addPostGroup('postGroup');
            }}
          >
            添加岗位组
          </Button>
        </div>
        <LeftStructureTree
          treeData={postGroupTreeData}
          treeType={"postGrouptab"}
          editPostGroup={(record)=>editPostGroup(record)}
          addPostGroup={(record)=>addPostGroup('post')}
          delPostGroup={(record)=>delPostGroup('record')}
        />
      </div>
      <div className="table-con">
        <div className="operate-area">
          <Button type="primary" className="add-user-btn">
            添加学员
          </Button>
          <Button className="del-user-btn">移出学员</Button>
        </div>
        <UserTable />
      </div>
      {addOrEditPostGroupShow && (
        <AddOrEditPostGroupModal
          onClose={() => {
            closeAddOrEditPostGroupModal();
          }}
          onConfirm={() => {
            confirmAddOrEditPostGroup();
          }}
          title={postGroupModalTitle}
          modalType={postGroupModalType}
          modalOperateType={operatePostGroupModalType}
          postGroupName={postGroupName}
          postGroupTreeData={postGroupTreeData}
          label={postGroupModalLable}
        />
      )}
    </div>
  );
}

export default withRouter(PostGroupTabCon);
