import React from 'react';
import { Tooltip, Input, Radio, Table } from 'antd';
import moment from 'moment';
import Breadcrumbs from "@/components/Breadcrumbs";
import PageControl from '@/components/PageControl';
import Service from "@/common/js/service";
import './OfflineCourseData.less';

const { Search } = Input;

export default class OfflineCourseData extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      courseId: window.getParameterByName('id'),
      query: {
        size: 10,
        current: 1,
      },
      loading: false,
      data: [],
      total: 0,
      courseName: '',
      calendarTime: [],
      fullJoin: 0,
      totalJoin: 0,
    }
  }

  componentDidMount() {
    this.getOfflineBasic();
    this.getOfflineCalendar();
  }

  getOfflineBasic = () => {
    const { courseId } = this.state;
    Service.Hades('public/hades/getOfflineCourseJoinBase', { courseId }).then((res) => {
      if (res.success) {
        const { result } = res;
        this.setState({
          courseName: result.courseName,
          fullJoin: result.fullJoin,
          totalJoin: result.totalJoin,
        });
      }
    })
  }

  getOfflineCalendar = () => {
    const { courseId } = this.state;
    Service.Hades('public/customerHades/offlineDateList', { courseId }).then((res) => {
      if (res.success) {
        console.log(result.calendarTime, _.groupBy(result.calendarTime, item => moment(item).format('YYYY-MM')), 1111111)
        this.setState({
          calendarTime: _.pluck(res.result, 'date'),
        })
      }
    });
  }

  getColumns = () => {
    const columns = [
      {
        title: '用户姓名',
        key: 'name',
        dataIndex: 'name',
        render: (val, record) => {
          return (
            <div>{record.name}</div>
          )
        }
      },
      {
        title: "手机号",
        key: "teacher",
        dataIndex: "teacher",
        render: (val, item) => {
          return (
            <div>{item.teacherName}</div>
          )
        },
      },
      {
        title: '报名时间',
        key: 'updated',
        dataIndex: 'updated',
        render: (val, item) => {
          return item.startTimeApply ? `${formatDate('MM-DD H:i', item.startTimeApply)} ~ ${formatDate('MM-DD H:i', item.endTimeApply)}` : '-'
        }
      },
      {
        title: '签到时间',
        key: 'signIn',
        dataIndex: 'signIn',
        sorter: true,
        render: (val) => {
          return formatDate('YYYY-MM-DD H:i', val) 
        }
      },
      {
        title: '签退时间',
        key: 'signOut',
        dataIndex: 'signOut',
        sorter: true,
        render: (val) => {
          return formatDate('YYYY-MM-DD H:i', val) 
        }
      },
    ];
    return columns;
  }

  handleChangeTable = () => {

  }

  render() {
    const {
      query,
      loading,
      data,
      total,
      courseName,
      fullJoin,
      totalJoin,
    } = this.state;
    return (
      <div className="page offline-course-data">
        <Breadcrumbs
          navList="参与数据"
          goBack={() => {
            window.RCHistory.goBack();
          }}
        />
        <div className="box">
          <div className="offline-name">课程名称：{courseName}</div>
          <div className="offline-application">报名总人数：{totalJoin}</div>
          <div className="offline-application">
            完成考勤总人数<Tooltip title="根据上课日期，在规定时间内完成签到和签退的用户数"><span className="icon iconfont">&#xe7c4;</span></Tooltip>：{fullJoin}
          </div>
        </div>
        <div className="box data-box">
          <div className="left-box">
            <div className="left-title">上课日期</div>
            <div className="left-calendar">
              <div className="icon-box">
                <span className="icon iconfont">&#xe79c;</span>
              </div>
              <div className="calendar-text">2021年5月</div>
              <div className="icon-box">
                <span className="icon iconfont">&#xe79b;</span>
              </div>
            </div>
            <div className="date-list">
              <div className="date-item">5月1日（周五）</div>
            </div>
          </div>
          <div className="right-box">
            <div className="selected-date">5月1日</div>
            <div className="detail-data">
              <span className="icon iconfont">&#xe89f;</span>
              <span className="data-text">报名人数：100</span>
              <span className="icon iconfont">&#xe89e;</span>
              <span className="data-text">完成考勤数<Tooltip title="当日在规定时间内完成签到和签退的用户数"><span className="icon iconfont">&#xe7c4;</span></Tooltip>：99</span>
              <span className="icon iconfont">&#xe8a0;</span>
              <span className="data-text">签到人数：99</span>
              <span className="icon iconfont">&#xe89d;</span>
              <span className="data-text">签退人数：99</span>
            </div>
            <div className="detail-filter">
              <Search
                className="search-input"
                placeholder="搜索用户姓名/手机号"
                style={{ width: 200, marginRight: 24 }}
                enterButton={<span className="icon iconfont">&#xe832;</span>}
              />
              <div className="filter-box">
                <span className="label">签到情况：</span>
                <Radio.Group
                  defaultValue="YES"
                >
                  <Radio value="YES">已签到</Radio>
                  <Radio value="NO">未签到</Radio>
                </Radio.Group>
              </div>
              <div className="filter-box">
                <span className="label">签退情况：</span>
                <Radio.Group
                  defaultValue="YES"
                >
                  <Radio value="YES">已签退</Radio>
                  <Radio value="NO">未签退</Radio>
                </Radio.Group>
              </div>
            </div>
            <Table
              bordered
              size="middle"
              pagination={false}
              columns={this.getColumns()}
              loading={loading}
              dataSource={data}
              onChange={this.handleChangeTable}
              rowKey={(row) => row.liveCourseId}
            />
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page) => {
                const queryStates = _.clone(query);
                queryStates.current = page;
                this.setState({ query: queryStates });
              }}
            />
          </div>
        </div>
      </div>
    )
  }
}