import React from 'react';
import { withRouter } from "react-router-dom";
import { Table,  Button, Modal } from 'antd';


import dealTimeDuration from '../utils/dealTimeDuration';

import { PageControl } from "@/components";
import Bus from '@/core/bus';



import './DataList.less';
const liveTypeMap = {
  USER: "学生",
  ANCHOR: "老师",
  ADMIN: "助教",
};
class PlaybackData extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      playbackData: [],
      current: 1,
      size: 10,
      total: 0
    }
  }

  componentDidMount() {
    this.fetchPlaybackList();
  }

  fetchPlaybackList = (page = 1) => {
    const { size } = this.state
    const params = {
      liveCourseId: getParameterByName("id"),
      current: page,
      size: size
    }
    // window.axios
    //   .Apollo("public/businessLive/queryUserReplayRecordPage", params)
    //   .then((res) => {
    //     if (res.result) {
    //       const { records = [], current, size, total } = res.result;
    //       this.setState({
    //         playbackData: records,
    //         current,
    //         size,
    //         total
    //       });
    //     }
    //   });
  };
  getPlaybackColumns() {
    const columns = [
      {
        title: "观看用户",
        dataIndex: "userName",
      },
      {
        title: "手机号",
        dataIndex: "phone"
      },
      {
        title: "观看者类型",
        dataIndex: "liveRole",
        render: (text) => <span>{liveTypeMap[text]}</span>,
      },
      {
        title: "开始观看时间",
        dataIndex: "entryTime",
        render: (text) => (
          <span>{text ? formatDate("YYYY-MM-DD H:i", parseInt(text)) : '-'}</span>
        ),
      },

      {
        title: "观看时长",
        dataIndex: "lookingDuration",
        render: (text) => {
          return <span>{text ? dealTimeDuration(text) : '-'}</span>;
        },
      },
    ];
    return columns;
  }
  // 导出
  handleplaybackExport() {
    const type = getParameterByName("type");
    const url = type === 'large' ? 'public/businessLive/exportLargeClassLiveAsync' : 'public/businessLive/exportClassInteractionLiveSync';
    // window.axios.Apollo(url, {
    //   liveCourseId: getParameterByName("id"),
    //   exportLiveType: 0
    // }).then((res) => {
    //   Bus.trigger('get_download_count'); 
    //   Modal.success({
    //     title: '导出任务提交成功',
    //     content: '请前往右上角的“' + window.NewVersion?'任务中心' : '导出中心' + '”进行下载',
    //     okText: <span id="I_know">我知道了</span>,
    //   });
    // })
  }

  render() {
    const { playbackData, total, current,  size} = this.state
    return (
      <div>
        <Button onClick={() => {this.handleplaybackExport()}}>导出</Button>
        <Table
          size="small"
          columns={this.getPlaybackColumns()}
          dataSource={playbackData}
          pagination={false}
          style={{ margin: '16px 0' }}>
        </Table>
        <PageControl
          size="small"
          current={current - 1}
          pageSize={size}
          total={total}
          toPage={(page) => {
            this.fetchPlaybackList(page + 1);
          }}
        />
      </div>
    )
  }
}

export default withRouter(PlaybackData);