import React from "react";
import { withRouter } from "react-router-dom";
import { Tabs } from "antd";

import Breadcrumbs from "@/components/Breadcrumbs";
import WatchDataHeader from "@/components/WatchDataHeader";
import CourseData from "./CourseData";
import PlaybackData from "./PlayBackData";
import WatchDataModal from "./WatchDataModal";
// import './WatchData.less';
import ENUM from '../ENUM'

class WatchData extends React.Component {
  constructor(props) {
    super(props);
    const type = getParameterByName("type");
    const id = getParameterByName("id");
    this.state = {
      title: type === 'LIVE' ? "上课数据" : '观看数据',
      type,
      id
    };
  }
  handChangeTitle = (title) => {
    this.setState({
      title,
    });
  };
  render() {
    const { type, title, id } = this.state;
    return (
      <div className="page data-list">
        <Breadcrumbs
          navList={title}
          goBack={() => {
            RCHistory.goBack();
          }}
        />
        <WatchDataHeader
          type={ENUM.CourseTypeEnum[type]}
          courseName={localStorage.getItem("WatchData_CourseName")}
          color="#2966FF"
        />

        <div className="box">
          {type === "LIVE" && (
            <Tabs defaultActiveKey="上课记录" onChange={this.handChangeTitle}>
              <Tabs.TabPane tab="上课记录" key="上课记录">
                <CourseData></CourseData>
              </Tabs.TabPane>

              <Tabs.TabPane tab="回放记录" key="观看数据">
                <PlaybackData></PlaybackData>
              </Tabs.TabPane>
            </Tabs>
          )}

          {type !== "LIVE" && (
            <WatchDataModal type="videoCourseList" id={id} type={type}/>
          )}
        </div>
      </div>
    );
  }
}

export default withRouter(WatchData);
