/*
 * @Author: 吴文洁
 * @Date: 2020-04-29 10:26:32
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-05 09:36:18
 * @Description: 内容线路由配置
 */
import EmployeesManagePage from '@/modules/store-manage/EmployeesManagePage';
import personalInfoPage from '@/modules/personalInfo';
import UserManagePage from '@/modules/store-manage/UserManagePage';
import StoreDecorationPage from '@/modules/store-manage/StoreDecorationPage';
import CourseCatalogPage from '@/modules/store-manage/CourseCatalogPage';
import LiveCoursePage from '@/modules/course-manage/LiveCoursePage';
import AddLivePage from '@/modules/course-manage/AddLive'
import VideoCoursePage from '@/modules/course-manage/video-course'
import AddVideoCoursePage from '@/modules/course-manage/video-course/AddVideoCourse'
import DataList from '@/modules/course-manage/DataList/DataList';
import ClassBook from '@/modules/resource-disk';
import ResourceDisk from '@/modules/resource-disk';
import SwitchRoute from '@/modules/root/SwitchRoute';
import QuestionBankIndex from '@/modules/teach-tool/QuestionBankIndex';
import QuestionCategoryManage from '@/modules/teach-tool/QuestionCategoryManage';
import AddNewQuestion from '@/modules/teach-tool/AddNewQuestion';

const mainRoutes = [
  {
    path: '/employees-manage',
		component: EmployeesManagePage,
		name: '员工管理'
  },
  {
    path: '/personal-info',
		component: personalInfoPage,
		name: '个人信息'
  },
  {
    path: '/user-manage',
		component: UserManagePage,
		name: '用户管理'
  },
  {
    path: '/store-decoration',
		component: StoreDecorationPage,
		name: '店铺装修'
  },
  {
    path: '/course-catalog',
		component:CourseCatalogPage,
		name: '课程分类'
  },
  {
    path: '/live-course',
		component:LiveCoursePage,
		name: '直播课'
  },
  {
    path: '/video-course',
		component:VideoCoursePage,
		name: '视频课'
  },
  {
    path: '/create-live-course',
		component:AddLivePage,
		name: '创建直播课'
  },
  {
    path: '/create-video-course',
		component:AddVideoCoursePage,
		name: '创建视频课'
  },
  {
    path: '/resource-disk',
		component:ResourceDisk,
		name: '资料云盘'
  },
  {
    path: '/question-bank-index',
		component:QuestionBankIndex,
		name: '题库'
  },
  {
    path: '/question-category-manage',
		component:QuestionCategoryManage,
		name: '分类管理'
  },
  {
    path: '/create-new-question',
		component:AddNewQuestion,
		name: '新增题目'
  },
  {
    path: '/switch-route',
		component: SwitchRoute,
		name: '登录后跳转承载页'
  }
]

export default mainRoutes;