/*
 * @Author: leehu 
 * @Date: 2017-09-01 16:29:44 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2019-12-09 15:03:40
 */
import React from 'react';
import { Menu, Icon, Checkbox, Button, Input, Spin, Select, Row } from 'antd';
import "./StaticSelect.less";
class StaticSelect extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      close: true,
      dataSet: [],
      visible: false,
      loading: false,
      selectedIds: this.props.defaultValue,
      selected: props.selected || [],
      query: {
        showNumber: 100,
      },
    }
    this.reset = () => {
      this.setState({ selectedIds: null })
    }
  }

  componentDidMount() {
    const dataSet = [];
    _.map(_.allKeys(this.props.dataSource), (key) => {
      this.props.dataSource[key] && dataSet.push({ id: key, name: this.props.dataSource[key] });
    });
    this.setState({ dataSet: dataSet });
  }

  componentWillReceiveProps(nextProps) {
    const dataSet = _.isArray(nextProps.dataSource) ? nextProps.dataSource : [];
    !_.isArray(nextProps.dataSource) && _.map(_.allKeys(nextProps.dataSource), (key) => {
      nextProps.dataSource[key] && dataSet.push({ id: key, name: nextProps.dataSource[key] });
    });
    this.setState({ dataSet: dataSet });
  }



  handleSelect = (id) => {
    if (!this.props.multiple) {
      this.props.onSelect({ id });
      return;
    }
    this.props.onSelect(id);

  }




  render() {
    let defprops = {}
    if (this.props.multiple) {
      defprops.mode = 'multiple'
    }

    if (this.props.id) {
      defprops.id = this.props.id
    }
    if(this.props.onFocus){
      defprops.onFocus = this.props.onFocus;
    }
    const { objectProps } = this.props;

    return (
      <div className={classNames("common-select staticSelect", { 'common-select-active': this.state.visible })} style={this.props.style}>
        {
          !!this.props.label && <div className='label'> {this.props.label}:</div>
        }
        <Select
          id={this.props.id}
          {...defprops}
          showSearch={this.props.showSearch}
          // style={{ width: '100%' }}
          disabled={this.props.disabled}
          allowClear={this.props.allowClear}
          placeholder={this.props.placeholder}
          value={this.props.defaultValue || undefined}
          defaultValue={this.props.defaultValue}
          onChange={this.handleSelect}
          filterOption={(input, option) => option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0}
          dropdownClassName={this.props.dropdownClassName}
        >
          {
            _.map(this.state.dataSet, (item, index) => {
              return <Select.Option id={this.props.id+'_item_'+index} key={this.props.id+''+index} value={item.id} title={item.name}>{item.name}</Select.Option>
            })
          }
        </Select>

      </div>
    )
  }
}

StaticSelect.propTypes = {

};

StaticSelect.defaultProps = {
  onSelect: () => { },
  showSearch: true,
  allowClear: true,
  defaultValue: '',
  placeholder: '请选择',
  dataSource: {},
  style: {},
  keyName: 'name',
  multiple: false,
  allSelectName: '全部班级',
  width: 100,
  student: true,
  dropdownClassName: '',
}

export default StaticSelect;