import React from 'react';
import { Button } from 'antd';
import { withRouter } from 'react-router-dom';
import User from '@/common/js/user';
import './ExpiredCourseList.less';

function ExpiredCourseList(props) {
 
  return (
    <div className="expired-course-list">
        { props.expiredCourseList.map((item,index)=>{
            return  <div className="course-item">
                    <div className="course-left">
                        <div className="course-status">
                            未成功开课
                        </div>
                        <div className="course-info">
                            <div className="course-type">
                                { item.courseType === "LIVE" &&
                                    <span>直播课</span>
                                }
                                 { item.courseType === "VOICE " &&
                                    <span>视频课</span>
                                }
                            </div>
                            <div className="course-instro">
                                <div className="course-name">
                                    {item.courseName}
                                </div>
                                <div className="task-name">
                                    {item.taskName}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div className="course-time">
                        上课时间：{formatDate('YYYY-MM-DD H:i', item.startTime)}
                    </div>
                </div>
            })
           
        }
       
    </div>
  );
}
export default withRouter(ExpiredCourseList)
