/*
 * @Author: wufan
 * @Date: 2020-12-26 11:51:14
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-26 15:04:26
 * @Description: 登录后跳转承载页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";

import { withRouter } from "react-router-dom";
import User from "@/common/js/user";

interface SwitchProps {}

function SwitchRoute(props: SwitchProps) {
  useEffect(() => {
    const userRole = User.getUserRole();

    /**
     * 角色登录后跳转
     * 管理员和店铺管理员登录后跳转到直播课列表页面
     * 讲师登录后跳转资料云盘页面
     */
    switch (userRole) {
      case "CloudManager":
        window.RCHistory.replace({
          pathname: `/redirect-to-live-course`,
        });
        break;
      case "StoreManager":
        window.RCHistory.replace({
          pathname: `/redirect-to-live-course`,
        });
        break;
      case "CloudLecturer":
        window.RCHistory.replace({
          pathname: `/redirect-to-resource-disk`,
        });
        break;
    }
  }, [User.getUserRole()]);
  return <div></div>
}

export default SwitchRoute;
