import React from 'react';
import { Modal, Table, Tooltip } from "antd";
import { ShowTips, PageControl } from "@/components";
import "./AccountChargeModal.less";

class ChargingDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      query: {
        current: 1,
        size: 10,
        liveCourseId: props.liveCourseId,
      },
      totalCount: 0,
      list: [],
      teacherList: [],
    };
  }
  componentDidMount() {
    // 发请求
    this.handleToPage();
    this.getTeacherData();
  }
  handleToPage = (page = 1) => {
    const params = _.clone(this.state.query);
    params.current = page;
    axios
      .Apollo("public/businessLive/queryStudentVisitData", params)
      .then((res) => {
        if (res.result) {
          const { records = [], total } = res.result;
          this.setState({
            list: records,
            totalCount: total,
            query: params,
          });
        }
      });
  };
  getTeacherData = () => {
    window.axios
      .Apollo("public/businessLive/queryTeacherVisitData", {
        liveCourseId: this.props.liveCourseId,
      })
      .then((res) => {
        if (res.result) {
          const teacherList = [res.result];
          this.setState({
            teacherList,
          });
        }
      });
  };
  dealTimeDuration = (time) => {
    const diff = Math.floor(time % 3600);
    let hours = Math.floor(time / 3600);
    let mins = Math.floor(diff / 60);
    let seconds = Math.floor(time % 60);
    hours = hours < 10 ? "0" + hours : hours;
    mins = mins < 10 ? "0" + mins : mins;
    seconds = seconds < 10 ? "0" + seconds : seconds;
    return hours + ":" + mins + ":" + seconds;
  };
  getColumns = (type) => {
    const columns = [
      {
        title: type == "student" ? "学生姓名" : "老师姓名",
        dataIndex: "userName",
      },
      {
        title: "手机号",
        dataIndex: "phone",
        render: (text, record) => {
          return <p>{text}</p>;
        },
      },
      {
        title: "累计在线时长",
        dataIndex: "totalDuration",
        render: (text, record) => {
          return <span>{text ? this.dealTimeDuration(text) : '-'}</span>;
        },
      },
      {
        title: (
          <span>
            是否计费&nbsp;
            <Tooltip title="仅对累计在线时长≥10分钟的老师或学员计费">
              <span className="icon iconfont">&#xe6f2;</span>
            </Tooltip>
          </span>
        ),
        dataIndex: "type",
        render: (text, record) => {
          return <span>{record.totalDuration > 600 ? "计费" : "不计费"}</span>; //大于十分钟的计费
        },
      },
    ];
    return columns;
  };
  render() {
    const { list, query, totalCount, teacherList } = this.state;
    return (
      <Modal
        title="计费人数详情"
        visible={true}
        width={680}
        maskClosable={false}
        className="charging-detail-modal"
        footer={null}
        onCancel={() => {
          this.props.close();
        }}
      >
        <div>
          <div style={{ marginBottom: 16 }}>
            <div className="detail-title">老师详情</div>
            <Table
              size="middle"
              columns={this.getColumns("teacher")}
              dataSource={teacherList}
              pagination={false}
              bordered
            />
          </div>
          <div className="detail-title">学生详情</div>
          <Table
            size="middle"
            columns={this.getColumns("student")}
            dataSource={list}
            pagination={false}
            bordered
          />
          <PageControl
            size="small"
            current={query.current - 1}
            pageSize={query.size}
            total={totalCount}
            toPage={(page) => {
              this.handleToPage(page + 1);
            }}
          />
        </div>
      </Modal>
    );
  }
}

export default ChargingDetailModal;
