/*
 * @Description: 
 * @Author: zangsuyun
 * @Date: 2021-03-13 10:57:14
 * @LastEditors: zangsuyun
 * @LastEditTime: 2021-03-13 17:16:44
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import PropTypes from 'prop-types';
import React from 'react'

// import { Modal } from 'antd';
import './TableSelectedData.less';

class TableSelectedData extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    return (
      <div className={this.props.className+' selected-data-box'}>
        <span className="icon iconfont">&#xe61d;</span>
        <span className="selected-text">{'已选择'+this.props.selectedNum+'项'}</span>
        <span className="click-clear" onClick={this.props.clearSelectedData}>清空</span>
      </div>
    )
  }
}

TableSelectedData.propTypes = {
  className: PropTypes.string,        // class
  selectedNum: PropTypes.number,      // 已选择人数
  clearSelectedData: PropTypes.func,  // 取消全部选择
};

TableSelectedData.defaultProps = {
  className: '',
  selectedNum: 0,
  clearSelectedData: function () {
  }
}

export default TableSelectedData