/*
 * @Author: 吴文洁
 * @Date: 2020-08-05 10:07:47
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-03-04 10:26:07
 * @Description: 图文课新增/编辑页
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */

import React from 'react';
import { Button, Input, Radio, message, Modal,Cascader} from 'antd';
import $ from 'jquery';

import { DISK_MAP, FileTypeIcon, FileVerifyMap } from '@/common/constants/academic/lessonEnum';
import { ImgCutModalNew } from '@/components';
import ShowTips from "@/components/ShowTips";
import Breadcrumbs from "@/components/Breadcrumbs";
import Bus from '../../../core/bus'
import AddGraphicsIntro from './components/AddGraphicsIntro';
import SelectStudent from '../modal/select-student';
import SelectPrepareFileModal from '../../prepare-lesson/modal/SelectPrepareFileModal';
import PreviewGraphicsModal from '../modal/PreviewGraphicsModal';
import StoreService from "@/domains/store-domain/storeService";
import Service from '@/common/js/service';
import { randomString } from '@/domains/basic-domain/utils';
import User from '@/common/js/user';
import _ from "underscore";
import Upload from '@/core/upload';
import './AddGraphicsCourse.less';

const EDIT_BOX_KEY = Math.random();
const fieldNames  = { label: 'categoryName', value: 'id', children: 'sonCategoryList' };

//添加课程时课程默认的一些值
const defaultShelfState = 'YES';
const whetherVisitorsJoin = 'NO'
const defaultCoverUrl = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';
let cutFlag = false;

class AddGraphicsCourse extends React.Component {

  constructor(props) {
    super(props);

    const id = getParameterByName("id");
    const pageType = getParameterByName("type");

    this.state = {
      id,                        // 图文课ID,编辑的时候从URL上带过来
      pageType,                  // 页面类型: add->新建 edit->编辑
      imageFile: null,           // 需要被截取的图片
      courseName: null,        // 图文课名称
      courseMedia: '',
      introduce: '',
      courseMediaId: null,     // 图文课链接
      coverId: null,             // 图文封面的recourceId
      coverUrl: defaultCoverUrl,            // 图文课封面
      studentList: [],           // 上课学员列表
      shelfState:'YES',          //是否开启店铺展示
      diskList: [],              // 机构可见磁盘目录
      selectedFileList: [],      // 已经从资料云盘中勾选的文件
      showCutModal: false,       // 是否显示截图弹窗
      showSelectVideoModal: false,
      studentModal: false,
      categoryName:null, //分类名称
      courseCatalogList:[], //分类列表
      categoryId:null, //分类的Id值
      whetherVisitorsJoin: 'NO', // 是否允许游客加入
      isContent: true,
    }
  }

  componentDidMount() {
    this.initBus()
  }

  componentWillMount() {
    const { id, pageType } = this.state;
    this.getCourseCatalogList();
    if (pageType === 'edit') {
      this.handleFetchScheudleDetail(id);
    }
  }

  componentWillUnmount() {
    this.removeBus();
  }

  initBus = () => {
    Bus.bind('graphicsEditorImage', this.uploadImage)
    Bus.bind('graphicsEditorVideo', this.uploadVideo)
  }

  removeBus = () => {
    Bus.unbind('graphicsEditorImage', this.uploadImage)
    Bus.unbind('graphicsEditorVideo', this.uploadVideo)
  }

  uploadImage = () => {
    this.setState({ showSelectImageModal: true })
  }

  uploadVideo = () => {
    this.setState({ showSelectVideoModal: true })
  }

  //获取分类列表
  getCourseCatalogList = ()=>{
    StoreService.getCourseCatalogList({current:1,size:1000}).then((res) => {
        this.setState({
          courseCatalogList:res.result.records
        })
    });
  }
  
  catalogChange= (value, options) => {
    const changeValueLength = value.length;
    switch (changeValueLength){
      case 1:
        this.setState({ categoryId: value[0], categoryName: options[0].categoryName });
      break;
      case 2:
        this.setState({ categoryId: value[1], categoryName: `${options[0].categoryName}-${options[1].categoryName}` });
      break;
      default:
        this.setState({ categoryId: null, categoryName: '' });
      break;    
    }
  }
  // 获取图文课详情
  handleFetchScheudleDetail = (courseId) => {
    Service.Hades('public/hades/mediaCourseDetail',{
      courseId
    }).then((res) => {
      const { result = {} } = res || {};
      const {
        courseName,
        shelfState,
        whetherVisitorsJoin,
        courseMediaVOS,
        categoryOneName,
        categoryTwoName,
        categoryId
      } = result;
      let coverId;
      let coverUrl = this.state.coverUrl;
      let hasIntro = false;
      
      courseMediaVOS.map((item) => {
        switch (item.contentType){
          case "COVER":
            coverId = item.mediaContent;
            coverUrl = item.mediaUrl;
          break;
          case "SCHEDULE":
            this.getTextDetail('courseMedia', item.mediaUrl);
            break;
          case "INTRO":
            hasIntro = true;
            this.getTextDetail('introduce', item.mediaUrl);
            break;  
          default:
            break;
        }
        return item;
      })
      
      let  categoryName;
      if( categoryTwoName ){
        categoryName = `${categoryOneName}-${categoryTwoName}`;
      }else{
        categoryName = `${categoryOneName}`;
      }
      this.setState({
        loadintroduce: !hasIntro,
        coverId,
        coverUrl,
        courseName,
        shelfState,
        whetherVisitorsJoin,
        categoryName,
        categoryId
      });
    })
  }

  getTextDetail = (key, url) => {
    $.ajax({
      data: {},
      type: 'GET',
      url,
      contentType:'application/x-www-form-urlencoded; charset=UTF-8',
      success: (res) => {
        this.setState({ [key]: res, [`load${key}`]: true });
      }
    })
  }

  handleGoBack = () => {
    const {
      coverId,
      videoName,
      videoDuration,
      courseName,
      courseMediaId,
      categoryId,
      shelfState,
      whetherVisitorsJoin
    } = this.state;
    if(videoName || videoDuration || courseMediaId || categoryId || courseName || coverId ||  shelfState !== defaultShelfState || whetherVisitorsJoin !== whetherVisitorsJoin ){
      Modal.confirm({
        title: '确认要返回吗?',
        content: '返回后，本次编辑的内容将不被保存。',
        okText: '确认返回',
        cancelText: '留在本页',
        icon: <span className="icon iconfont default-confirm-icon">&#xe6f4;</span>,
        onOk: () => {
          RCHistory.goBack();
        }
      });
    }else{
      RCHistory.goBack();
    }
  }

  // 修改表单
  handleChangeForm = (field, value, coverUrl) => {
    this.setState({
      [field]: value,
      coverUrl: coverUrl ? coverUrl : this.state.coverUrl
    });
  }
  
  // 显示选择学员弹窗
  handleShowSelectStuModal = () => {
    this.setState({ studentModal : true });

    const { studentList, selectedStuList } = this.state;
    // const _studentList = _.map(studentList, (item) => { 
    //   return item.studentId
    // })
    const studentModal = (
      <SelectStudent
        showTabs={true}
        type="videoCourse"
        onSelect={this.handleSelectStudent}
        after={true} //表明是不是上课后的状态
        studentList={studentList}
        close={() => {
          this.setState({
            studentModal: null,
          });
        }}
      />
    )
    this.setState({ studentModal });
  }

  handleSelectStudent = (studentIds) => {
    let studentList = [];
    _.each(studentIds, (item) => {
      studentList.push({ studentId: item });
    });
    // this.setState({ studentModal: null });
    this.setState({ studentList  });
    this.setState({ studentModal : false });
  }
  
  // 显示预览弹窗
  handleShowPreviewModal = () => {
    const {
      coverUrl,
      courseName,
      courseMedia,
      introduce,
      categoryName,
    } = this.state;

    const courseBasinInfo = {
      coverUrl,
      courseName,
      categoryName
    }
    const courseIntroInfo = {
      courseMedia,
      introduce,
    }
    const previewGraphicsModal = (
      <PreviewGraphicsModal
        courseBasicInfo={courseBasinInfo}
        courseIntroInfo={courseIntroInfo}
        close={() => {
          this.setState({
            previewGraphicsModal: null
          })
        }}
      />
    );

    this.setState({ previewGraphicsModal });
  }
  
  // 选择图文
  handleSelectVideo = (file) => {
    this.setState({
      showSelectVideoModal: false
    })
    const { ossUrl } = file;
    const { courseMedia } = this.state;
    this.setState({
      courseMedia: `${courseMedia}<p style="width: 100%;padding-top: 56.25%;position: relative;"><iframe style="position: absolute;width: 100%;height: 100%;top: 0;left: 0;" src="${ossUrl}"></iframe><br/></p><p><br/></p>`
    });
  }

  handleSelectImage = (file) => {
    this.setState({
      showSelectImageModal: false
    })
    const { ossUrl } = file;
    const { courseMedia, introduce, isContent } = this.state;
    this.setState({
      [isContent ? 'courseMedia' : 'introduce']: `${isContent ? courseMedia : introduce}<p><img style="max-width: 100%;" src="${ossUrl}" /><br/><p>`
    });
  }

  handleSelectCover = (file)=> {
    this.uploadCoverImage(file);
  }
  
  //上传图片
  uploadCoverImage = (imageFile) => {
    debugger
    const { folderName } = imageFile;
    const fileName = window.random_string(16) + folderName.slice(folderName.lastIndexOf("."));
    const self = this;
    this.setState(
      {
        visible: true,
      },
      () => {
        setTimeout(() => {
          const okBtnDom = document.querySelector("#headPicModal");
          const options = {
            size: [500, 282],
            ok: okBtnDom,
            maxZoom: 3,
            style: {
              jpgFillColor: "transparent",
            },
            done: function (dataUrl) {
              clearTimeout(self.timer);
              self.timer = setTimeout(() => {
                if ((self.state.rotate != this.rotate()) || (self.state.scale != this.scale())) {
                  const _dataUrl = this.clip()
                  const cutImageBlob = self.convertBase64UrlToBlob(_dataUrl);
                  self.setState({
                    cutImageBlob,
                    dataUrl: _dataUrl,
                    rotate: this.rotate(),
                    scale: this.scale()
                  })
                }

              }, 500)

              const cutImageBlob = self.convertBase64UrlToBlob(dataUrl);
              self.setState({
                cutImageBlob,
                dataUrl
              })
              setTimeout(() => {
                cutFlag = false;
              }, 2000);
            },
            fail: (failInfo) => {
              message.error("图片上传失败了，请重新上传");
            },
            loadComplete: function (img) {
              setTimeout(() => {
                const _dataUrl = this.clip()
                self.setState({
                  dataUrl: _dataUrl,
                  hasImgReady: true 
                })
              }, 100)

            },
          };
          const imgUrl = `${imageFile.ossUrl}?${new Date().getTime()}`
          if (!this.state.photoclip) {
            const _photoclip = new PhotoClip("#headPicModal", options);
            _photoclip.load(imgUrl);
            this.setState({
              photoclip: _photoclip,
            });
          } else {
            this.state.photoclip.clear();
            this.state.photoclip.load(imgUrl);
          }

        }, 200);
      }
    );
  };

  //获取resourceId
  getSignature = (blob, fileName) => {
    Upload.uploadBlobToOSS(blob, 'cover' + (new Date()).valueOf(),null,'signInfo').then((signInfo) => {
      this.setState({
        coverClicpPath:signInfo.fileUrl,
        coverId:signInfo.resourceId,
        visible: false
      },()=>this.updateCover())
    
    });
  };

  updateCover = () =>{
    const {coverClicpPath,coverId} = this.state
    this.setState({
      showSelectCoverModal: false,
      coverUrl:coverClicpPath,
      coverId:coverId
    })
  }

   // base64转换成blob
  convertBase64UrlToBlob = (urlData) => {
    const bytes = window.atob(urlData.split(",")[1]);
    const ab = new ArrayBuffer(bytes.length);
    const ia = new Uint8Array(ab);
    for (let i = 0; i < bytes.length; i++) {
      ia[i] = bytes.charCodeAt(i);
    }
    return new Blob([ab], { type: "image/png" });
  };

  // 保存
  handleSubmit = () => {
    const {
      id,
      coverId,
      pageType,
      courseName,
      courseMedia,
      introduce,
      categoryId,
      shelfState,
      whetherVisitorsJoin,
    } = this.state;

    const commonParams = {
      categoryId,
      courseName,
      coverId,
      operatorId:User.getStoreUserId(),
      storeId:User.getStoreId(),
      shelfState,
      whetherVisitorsJoin,
      courseType: 'PICTURE',
    };
    // 校验必填字段:课程名称, 课程图文
    this.handleValidate(courseName, courseMedia, categoryId).then((res) => {
      if (!res) return;
      Upload.uploadTextToOSS(courseMedia, `${randomString()}.txt`, (courseMediaId) => {
        Upload.uploadTextToOSS(introduce, `${randomString()}.txt`, (introduceId) => {
          this.submitRemote({
            id,
            pageType,
            commonParams,
            courseMediaId,
            introduceId,
          });
        }, () => message.warning('上传课程简介失败'));
      }, () => message.warning('上传课程内容失败'));
    });
  }

  submitRemote = (data) => {
    const { id, pageType, commonParams, courseMediaId, introduceId } = data;
    commonParams.courseMediaId = courseMediaId;
    commonParams.introduceId = introduceId;
    if (pageType === 'add') {
      Service.Hades('public/hades/createMediaCourse', commonParams).then((res) => {
        if (!res) return;
        message.success("新建成功");
        window.RCHistory.goBack();
      })
    } else {
      const editParams = {
        courseId:id,
        ...commonParams,
      }
      Service.Hades('public/hades/editMediaCourse', editParams).then((res) => {
        if (!res) return;
        message.success("保存成功");
        window.RCHistory.goBack();
      });
    }
  }

  handleValidate = (courseName, courseMedia, categoryId) => {
    return new Promise((resolve) => {
      if (!courseName) {
        message.warning('请输入课程名称');
        resolve(false);
        return false
      }
      if (!courseMedia) {
        message.warning('请输入课程内容');
        resolve(false);
        return false
      }
      if(!categoryId){
        message.warning('请选择课程分类');
        resolve(false);
        return false
      }
      // const textMedia = scheduleMedia.filter((item) => item.mediaType === 'TEXT');
      // for (let i = 0, len = textMedia.length; i < len; i++) {
      //   if (textMedia[i].mediaContentLength && textMedia[i].mediaContentLength.length > 1000) {
      //     message.warning(`第${i+1}个文字简介的字数超过了1000个字`);
      //     resolve(false);
      //     return false
      //   }
      // }
      resolve(true);
    });
  }

  render() {
    const {
      id,
      pageType,
      courseName,
      coverUrl,
      studentList,
      courseMedia,
      introduce,
      showCutModal,
      showSelectVideoModal,
      showSelectImageModal,
      diskList,
      imageFile,
      videoType,
      shelfState,
      categoryName,
      courseCatalogList,
      whetherVisitorsJoin,
      loadcourseMedia,
      loadintroduce,
      showSelectCoverModal,
      visible,
      hasImgReady,
      cutImageBlob,
    } = this.state;
    // 已选择的上课学员数量
    const hasSelectedStu = studentList.length;

    const courseWareIcon = FileVerifyMap[videoType] ? FileTypeIcon[FileVerifyMap[videoType].type] : FileTypeIcon[videoType];
    
    return (
      <div className="page add-video-course-page">
        <Breadcrumbs
          navList={pageType === "add" ? "新建图文课" : "编辑图文课"}
          goBack={this.handleGoBack}
        />

        <div className="box">
          <div className="show-tips">
            <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" />
          </div>

          <div className="form">
            <div className="course-name required">
              <span className="label">课程名称：</span>
              <Input
                value={courseName}
                placeholder="请输入图文课的名称（40字以内）"
                maxLength={40}
                style={{ width: 240 }}
                onChange={(e) => { this.handleChangeForm('courseName', e.target.value)}}
              />
            </div>

            <div className="cover-url flex mt16">
              <div className="label">封面图：</div>
              <div className="cover-url__wrap">
                <div className="img-content">
                  <img src={coverUrl} />
                </div>
                <div className="opt-btns">

                  <Button onClick={() => {
                    this.setState({
                      showSelectCoverModal: true
                    });
                  }}>{`${(pageType === 'add' && !coverUrl) ? '上传' : '修改'}封面`}</Button>
                  <div className="tips">建议尺寸1280*720px或16:9。封面图最大5M，支持jpg、jpeg和png。</div>
                </div>
              </div>
            </div>
            <div className="course-catalog required">
              <span className="label">课程分类：</span>
              { (pageType === 'add') && 
                <Cascader defaultValue={[categoryName]} options={courseCatalogList} displayRender={	label => label.join('-')}  fieldNames={fieldNames} onChange={this.catalogChange} style={{ width: 240 }} placeholder="请选择课程分类"  suffixIcon={<span className="icon iconfont" style={{fontSize:'12px',color:'#BFBFBF'}}>&#xe835;</span>}/>
              }
              { (pageType === 'edit' && categoryName ) && 
                <Cascader defaultValue={[categoryName]} options={courseCatalogList} displayRender={	label => label.join('-')}  fieldNames={fieldNames} onChange={this.catalogChange} style={{ width: 240 }} placeholder="请选择课程分类" suffixIcon={<span className="icon iconfont" style={{fontSize:'12px',color:'#BFBFBF'}}>&#xe835;</span>}/>
              }
            </div>
            <div className="intro-info mt16">
              <AddGraphicsIntro
                data={{
                  id,
                  courseMedia,
                  introduce,
                  shelfState,
                  whetherVisitorsJoin,
                  loadcourseMedia,
                  loadintroduce,
                }}
                onChange={this.handleChangeForm}
              />
            </div>
          </div>
        </div>

        <div className="footer">
          <Button onClick={this.handleGoBack}>取消</Button>
          <Button onClick={this.handleShowPreviewModal}>预览</Button>
          <Button type="primary" onClick={_.debounce(() => this.handleSubmit(), 3000, true)}>保存</Button>
        </div>
        
        {/* 选择备课文件弹窗 */}
        { showSelectVideoModal &&
          <SelectPrepareFileModal
            operateType="select"
            selectTypeList={['MP4']}
            accept="video/mp4"
            confirm={{
              title: '文件过大，无法上传',
              content: '为保障学员的观看体验，上传的图文大小不能超过2G',
            }}
            tooltip={'格式支持mp4，大小不超过2G'}
            isOpen={showSelectVideoModal}
            diskList={diskList}
            addVideo={true}
            onClose={() => {
              this.setState({ showSelectVideoModal: false })
            }}
            onSelect={this.handleSelectVideo}
          />
        }
        {showSelectImageModal && 
          <SelectPrepareFileModal
            key="basic"
            operateType="select"
            multiple={false}
            accept="image/jpeg,image/png,image/jpg"
            selectTypeList={['JPG', 'JPEG', 'PNG']}
            tooltip='支持文件类型：jpg、jpeg、png'
            isOpen={showSelectImageModal}
            onClose={() => {
              this.setState({ showSelectImageModal: false })
            }}
            onSelect={this.handleSelectImage}
          />
        }
        {showSelectCoverModal && 
          <SelectPrepareFileModal
            key="basic"
            operateType="select"
            multiple={false}
            accept="image/jpeg,image/png,image/jpg"
            selectTypeList={['JPG', 'JPEG', 'PNG']}
            tooltip='支持文件类型：jpg、jpeg、png'
            isOpen={showSelectCoverModal}
            onClose={() => {
              this.setState({ showSelectCoverModal: false })
            }}
            onSelect={this.handleSelectCover}
          />
        }
        <Modal
          title="设置图片"
          width={1080}
          visible={visible}
          maskClosable={false}
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
          onCancel={() => {
            this.setState({ visible: false });
          }}
          zIndex={10001}
          footer={[
            <Button
              key="back"
              onClick={() => {
                this.setState({ visible: false });
              }}
            >
              重新上传
            </Button>,
            <Button
              key="submit"
              type="primary"
              disabled={!hasImgReady}
              onClick={() => {
                if (!cutFlag) {
                  cutFlag = true;
                  this.refs.hiddenBtn.click();
                }
                this.getSignature(cutImageBlob);
              }}
            >
              确定
            </Button>,
          ]}
        >
          <div className="clip-box">
            <div
              id="headPicModal"
              ref="headPicModal"
              style={{
                width: "500px",
                height: "430px",
                marginBottom: 0,
              }}
            ></div>
            <div id="clipBtn" style={{ display: "none" }} ref="hiddenBtn"></div>
            <div className="preview-img">
              <div className="title">效果预览</div>
              <div id="preview-url-box" style={{width:500,height:282}}>
                <img src={this.state.dataUrl} style={{ width: '100%' }} alt="" />
              </div>
            </div>
          </div>
        </Modal>
        { this.state.previewGraphicsModal }
      </div>
    )
  }
}

export default AddGraphicsCourse;
