/*
 * @Author: 吴文洁
 * @Date: 2020-04-28 18:05:30
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-26 14:37:23
 * @Description: 
 */
import mainRoutes from './config/mainRoutes';
import redirectRoutes from './config/redirectRoutes';
import React  from 'react'
import { Redirect,HashRouter as Router,Route ,Switch} from 'react-router-dom';
import { createHashHistory } from 'history';
import App from '../modules/root/App';
import AppContext from '@/modules/root/AppContent';
import Login from '../modules/root/Login';
import CollegeManagePage from '../modules/root/CollegeManagePage';
import CreateCollege from '../modules/root/CreateCollege';
import _ from 'underscore';
import { asyncComponent } from 'react-async-component'
import SwitchRoute from '@/modules/root/SwitchRoute';
const history = createHashHistory();
window.RCHistory = _.extend({}, history, {
	push: (obj: any) => {
		history.push(obj)
	},
	pushState:  (obj: any) => {
		history.push(obj)
	},
	pushStateWithStatus: (obj: any) => {
		history.push(obj)
	},
	goBack: history.goBack,
    location: history.location,
	replace: (obj: any) => {
		history.replace(obj)
	}
});

const cache:any = {
	path: '',
	component: null
}
function dynamic (component:any) {
	const resolveComponent = component
	return asyncComponent({
		resolve: () => {
			const ts = resolveComponent()
			return ts
		},
	})
}

export const RootRouter = () => {
	return (
		<Router {...history}>
			<Switch>
				<Route key="1" exact path="/login" render={() => <Login />} />
				<Route key="1" exact path="/switch-route" render={() => <SwitchRoute />} />
				<Route key="1" exact path="/college-manage" render={() => <CollegeManagePage />} />
				<Route key="1" exact path="/college-manage/create" render={() => <CreateCollege />} />
				<Route key="2" path="/" render={() => <AppContext />} />
			</Switch>
		</Router>
	)
}

export const MainRoutes = () => {
	return (
		<Switch>
			{
				_.map(mainRoutes, ({
					path,
					component,
				}, key) => {
					return <Route
						key={key}
						path={path}
						render={() => {
							const Component = component;
							return <Component />
						}}
					/>
				})
			}
		</Switch>
	)
}
export const RedirectRoutes = () => {
	return (
		<Switch>
			{
				_.map(redirectRoutes, ({
					path,
					component,
				}, key) => {
					return <Route
						key={key}
						path={path}
						render={() => {
							const Component = component;
							return <Component />
						}}
					/>
				})
			}
		</Switch>
	)
}
