import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { Tabs } from 'antd';
import Service from '@/common/js/service';
import Breadcrumbs from "@/components/Breadcrumbs";
import DataInfo from './components/DataInfo'
import './index.less'

function DataCenter(props: any) {
    const { match: { params: { planId } } } = props;
    const [info, setInfo] = useState<any>({})

    useEffect(() => {
        getInfo()
    }, [])

    function getInfo() {
        Service.Hades('public/hades/getTrainingPlanDetail', { planId }).then((res: any) => {
            setInfo(res.result)
        })
    }

    return <div className="page train-data-center">
        <Breadcrumbs
            navList="培训任务详情"
            goBack={() => {
                props.history.goBack();
            }}
        />
        <DataInfo info={info} />
    </div>
}

export default withRouter(DataCenter)
