/*
 * @Author: yuananting
 * @Date: 2021-07-29 14:32:24
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-30 16:23:11
 * @Description: 任务中心-培训任务-新建-基本信息
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Form, Button, Input, Space, DatePicker, Radio, Tag, Col, message, Tooltip } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import { withRouter } from 'react-router-dom';
// import SelectOperatorModal from '../modal/SelectOperatorModal';
// import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import Upload from '@/core/upload';
import GraphicsEditor from '@/modules/course-manage/components/GraphicsEditor';
// import ImgClipModal from '@/components/ImgClipModal';
import moment from 'moment';
import './BasicInfo.less';

const { TextArea } = Input;
const { RangePicker } = DatePicker;

const FormItem = Form.Item;

function BasicInfo(props) {
  const { data } = props;
  const {
    planName,
    coverUrl,
    durationType,
    learnType,
    instro,
    endTime,
    enableState,
    operateType,
    selectOperatorList,
    percentCompleteLive,
    percentCompleteVideo,
    percentCompletePicture,
  } = data;
  const isDefaultCover = true;
  const helpStoreUsers = [
    {
      id: 1,
      name: 'y阿萨德at',
    },
    {
      id: 2,
      name: 'ASFSDFAtgdf',
    },
    {
      id: 3,
      name: 'sfasfasdffff',
    },
    {
      id: 4,
      name: 'fsaf',
    },
    {
      id: 5,
      name: '示范法as',
    },
    {
      id: 6,
      name: '会尽快个何况',
    },
    {
      id: 7,
      name: '千多',
    },
    {
      id: 8,
      name: '我二合一',
    },
    {
      id: 9,
      name: '发顺丰',
    },
    {
      id: 10,
      name: '时高时低',
    },
    {
      id: 11,
      name: 'ASFSDFAtgdf',
    },
    {
      id: 12,
      name: '撒的A',
    },
    {
      id: 13,
      name: '山东高速广东省广东省怪怪的',
    },
    {
      id: 14,
      name: '而言二',
    },
    {
      id: 15,
      name: '而已',
    },
    {
      id: 16,
      name: '一条鱼',
    },
    {
      id: 17,
      name: '水电费干啥',
    },
    {
      id: 18,
      name: 'AddTrainTask',
    },
  ];

  const assignList1 = [
    {
      id: 1,
      name: 'yat',
    },
    {
      id: 2,
      name: '而已',
    },
    {
      id: 3,
      name: '一条鱼',
    },
  ];
  const assignList2 = [
    {
      id: 1,
      name: 'yat',
    },
    {
      id: 2,
      name: 'ya发发送到发送到发送到撒旦法撒旦法师t',
    },
    {
      id: 3,
      name: '1111111111111111111111111111111111111111111111111111111',
    },
    {
      id: 4,
      name: 'fsaf',
    },
    {
      id: 5,
      name: '示范法as',
    },
    {
      id: 6,
      name: '示范法as水电费',
    },
    {
      id: 7,
      name: '千多',
    },
    {
      id: 8,
      name: 'y阿萨at',
    },
    {
      id: 9,
      name: '发顺丰',
    },
    {
      id: 10,
      name: 'iuyti第三方感受到',
    },
    {
      id: 11,
      name: 'ASFSDFAtgdf',
    },
    {
      id: 12,
      name: '撒的A',
    },
    {
      id: 13,
      name: '耳热耳热让他一人',
    },
    {
      id: 14,
      name: '而言二',
    },
    {
      id: 15,
      name: '而已',
    },
    {
      id: 16,
      name: '一条鱼',
    },
    {
      id: 17,
      name: '水电费干啥',
    },
    {
      id: 18,
      name: 'AddTrainTask',
    },
  ];

  // 使用默认封面图
  function handleResetCoverUrl() {
    // const isDefaultCover = coverUrl === defaultCover;
    // // 如果已经是默认图的话，不做任何任何处理
    // if (isDefaultCover) return;
    // message.success('已替换为默认图');
    // this.props.onChange('coverUrl', defaultCover);
    // setTimeout(() => {
    //   this.props.onChange('coverId', null);
    // }, 1000);
  }

  return (
    <div className='basic-info__form'>
      <Form>
        <FormItem label='培训任务名称' required>
          <Input
            value={planName}
            placeholder='请输入培训任务名称（20字以内）'
            maxLength={20}
            style={{ width: 300 }}
            // onChange={(e) => this.props.onChange('planName', e.target.value)}
          />
        </FormItem>
        <FormItem label='封面图'>
          <div className='cover__wrap'>
            <div className='opt-box'>
              <Button
                onClick={() => {
                  this.setState({
                    showSelectFileModal: true,
                  });
                }}>
                上传封面
              </Button>
              <span className={`default-btn ${isDefaultCover ? 'disabled' : ''}`} onClick={handleResetCoverUrl}>
                使用默认图
              </span>
              <div className='tips'>建议尺寸1280*720px或16:9。封面图最大5M，支持jpg、jpeg和png。</div>
            </div>
            <div className='img-box'>
              {isDefaultCover && <span className='default-tag'>默认图</span>}
              <img src={coverUrl} alt='' />
            </div>
          </div>
        </FormItem>
        <FormItem label='培训时间'>
          <div className='duration__wrap'>
            <Radio.Group value={durationType} onChange={(e) => props.onChange('durationType', e.target.value)}>
              <Space direction='vertical' size={16}>
                <Radio value='NEVER_EXPIRES'>
                  永久有效<span className='tips'>设置为“永久有效”，发布后任务开始生效，取消发布后失效</span>
                </Radio>
                <Radio value='FIXED_DURATION'>
                  固定时间段
                  {durationType === 'FIXED_DURATION' && (
                    <div className='picker-box'>
                      <RangePicker
                        style={{ width: 320 }}
                        showTime={{ defaultValue: [moment().add(10, 'minutes'), moment().add(10, 'minutes')] }}
                        ranges={{
                          近7天: [moment().add(10, 'minute'), moment().add(6, 'day').endOf('day')],
                          近1个月: [moment().add(10, 'minute'), moment().add(1, 'month').endOf('day')],
                          近3个月: [moment().add(10, 'minute'), moment().add(3, 'month').endOf('day')],
                        }}
                        // disabledDate={disabledDate}
                        // value={[examStartTime ? moment(Number(examStartTime)) : null, examEndTime ? moment(Number(examEndTime)) : null]}
                        // disabledTime={disabledRangeTime}
                        format='YYYY-MM-DD HH:mm'
                        // onChange={(date) => {
                        //   setStartTime(date && date[0]?.valueOf());
                        //   setExamEndTime(date && date[1]?.valueOf());
                        // }}
                      />
                    </div>
                  )}
                </Radio>
              </Space>
            </Radio.Group>
          </div>
        </FormItem>
        <FormItem label='学习模式' required extra={<div className='learning-model-tips'>提示：任务开始后学习模式将不允许更换</div>}>
          <div className='learning-model__wrap'>
            <Radio.Group value={learnType} onChange={(e) => props.onChange('learnType', e.target.value)}>
              <Space direction='vertical' size={16}>
                <Radio value='FREEDOM'>自由学习</Radio>
                <Radio value='BREAKTHROUGH_LEARNING'>
                  闯关学习
                  <Tooltip title='学员必须按顺序学习'>
                    <i
                      className='icon iconfont'
                      style={{
                        marginLeft: '5px',
                        cursor: 'pointer',
                        color: '#bfbfbf',
                        fontSize: '14px',
                        fontWeight: 'normal',
                      }}>
                      &#xe61d;
                    </i>
                  </Tooltip>
                </Radio>
              </Space>
            </Radio.Group>
          </div>
        </FormItem>
        <FormItem label='指派学员' required>
          <div className='item-btn'>添加指派对象</div>
          {assignList1.length + assignList2.length > 0 && (
            <Space size={'12'} direction={'vertical'} className='item-obj'>
              {assignList1.length > 0 && (
                <div className='obj-type-container'>
                  <div className='type-title'>已选组织：</div>
                  <div className='tag-box'>
                    {_.map(assignList1, (item) => {
                      return <Tag closable>{item.name}</Tag>;
                    })}
                  </div>
                </div>
              )}
              {assignList2.length > 0 && (
                <div className='obj-type-container'>
                  <div className='type-title'>已选学员：</div>
                  <div className='tag-box'>
                    {_.map(assignList2, (item) => {
                      return <Tag closable>{item.name}</Tag>;
                    })}
                  </div>
                </div>
              )}
            </Space>
          )}
        </FormItem>
        <FormItem label='协同人员'>
          <div className='item-btn'>添加协同者</div>
          {helpStoreUsers.length > 0 && (
            <div className='item-obj'>
              {_.map(helpStoreUsers, (item) => {
                return <Tag closable>{item.name}</Tag>;
              })}
            </div>
          )}
        </FormItem>
        <FormItem label='培训目的'>
          <GraphicsEditor
            maxLimit={1000}
            id='intro'
            isIntro={true}
            detail={{
              content: instro,
            }}
            onChange={(val) => {
              // this.changeIntro(val);
            }}
          />
        </FormItem>
      </Form>
    </div>
  );
}

export default BasicInfo;
