import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { Progress } from 'antd';
import ENUM from '../../emun'
const defaultCover = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';

function DataInfo(props: any) {

    return <div className="infoBox">
        <div className="left">
            <div className="banner">
                <img src={props.info.coverUrl || defaultCover} alt="" />
            </div>
            <div className="textBox">
                <div className="nameBox">
                    <div className="name">{props.info.planName}</div>
                    <div className="status" style={{ color: ENUM.trainStatus[props.info.status || 'UN_START'].color, background: ENUM.trainStatus[props.info.status || 'UN_START'].background }}>{ENUM.trainStatus[props.info.status || 'UN_START'].text}</div>
                </div>
                <div className="info">
                    <span>  {`创建人: 文小白 `}</span>
                    <span style={{ marginLeft: 24 }}>  {`培训时间：2021-07-01 00:00 至 2021-08-17 00:00`}</span>
                </div>
                <div className="info">
                    <div className="item">{`任务数: 98`}</div>
                    <div className="item">{`课程：98`}</div>
                    <div className="item">{`作业：4`}</div>
                    <div className="item">{`考试：4`}</div>
                </div>
            </div>


        </div>
        <div className="right">
            <div className="prog">
                <Progress type="circle" width={85} percent={75} strokeWidth={10} format={percent => <div className='wcl'>{`${percent}% `}  <div>完成率</div></div>} />
            </div>
            <div className="num">
                <div className="item">{`指派人数：${12}`}</div>
                <div className="item">{`学习人数：${12}`}</div>
                <div className="item">{`完成人数：${12}`}</div>
            </div>
        </div>
    </div>
}

export default withRouter(DataInfo)