/*
 * @Author: 吴文洁 
 * @Date: 2020-02-25 15:56:03 
 * @Last Modified by: wufan
 * @Last Modified time: 2020-07-09 12:07:14
 微官网相关常量
 */

import XMEnum from '../XMEnum';
const marketingToolsTabNames = [{ type: 'show', name:'小麦秀' },{type: 'coupon',name:'优惠券'} ];

const TabNames = [
  'brand', 'course', 'teacher', 'student',
  'environment', 'activity', 'material', 'news'
];

const TextEnum = new XMEnum([
  {
    module: 'BRAND_INTRO',
    name: 'brand',
    tabLabel: '品牌介绍',
    detailLabel: '机构详情',
    placeholder: '请填写简介,30字以内',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583836090586.png'
  },
  {
    module: 'CAMPUS_ENVIRON',
    name: 'environment',
    tabLabel: '校区环境',
    detailLabel: '校区详情',
    placeholder: '请填写简介,30字以内',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583836118436.png'
  },
  {
    module: 'ACTIVITY_STYLE',
    name: 'activity',
    tabLabel: '活动风采',
    nameLabel: '活动名称',
    coverLabel: '活动封面',
    detailLabel: '活动详情',
    coverWidth: 156,
    coverHeight: 80,
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583824443588.png'
  },
  {
    module: 'HOT_COURSE',
    name: 'course',
    tabLabel: '热门课程',
    nameLabel: '课程名称',
    introLabel: '课程简介',
    coverLabel: '课程封面',   
    detailLabel: '课程详情',
    placeholder: '请填写课程简介，例如：针对4~8岁的孩子，重点培养的基础绘画技能、激发艺术表现。30字以内',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583823404400.png'
  },
  {
    module: 'FACULTY_TEAM',
    name: 'teacher',
    tabLabel: '师资团队',
    nameLabel: '老师姓名',
    introLabel: '老师简介',
    coverLabel: '老师照片',
    detailLabel: '老师详情',
    placeholder: '请填写老师亮点，简短精炼，例如：5年教龄，名校毕业，平易近人。30字以内',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583823414781.png'
  },
  {
    module: 'STAR_STUDENT',
    name: 'student',
    tabLabel: '明星学员',
    nameLabel: '学员姓名',
    introLabel: '学员简介',
    coverLabel: '学员照片',
    detailLabel: '学员详情',
    placeholder: '请填写学员简介/宣言，例如： 持之以恒，必将有好的收获。闪亮之星小阮的学习之旅~。30字以内',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583823429407.png'
  },
  {
    module: 'STUDY_MATERIALS',
    name: 'material',
    tabLabel: '学习资料',
    nameLabel: '资料名称',
    coverLabel: '资料封面',
    detailLabel: '资料详情',
    coverWidth: 156,
    coverHeight: 80,
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583823443748.png'
  },
  {
    module: 'NEWS',
    name: 'news',
    tabLabel: '新闻动态',
    nameLabel: '新闻标题',
    coverLabel: '新闻封面',
    detailLabel: '新闻详情',
    coverUrl: 'https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1583823455499.png'
  },
])


export default TextEnum;
export {
  TabNames,
  marketingToolsTabNames
}