/*
 * @Author: 陈剑宇
 * @Date: 2020-10-28 14:27:07
 * @LastEditTime: 2021-02-28 14:22:13
 * @LastEditors: yuananting
 * @Description: 
 * @FilePath: /xiaomai-web-b/app/common/constants/punchClock/punchClock.js
 * @symbol_custom_string_obkoro1: Copyright © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from "react";
export const DEFAULT_IMG_URL = 'https://image.xiaomaiketang.com/xm/2MWCKBNiya.png';
export const DEFAULT_CALENDAR_TEXT = '<p>亲爱的同学：</p><p>欢迎参加《麦麦教育0基础21天英语打卡活动》，大家都知道21天养成一个好习惯。在未来的21天里，老师将和同学们一起完成21个打卡任务，0基础锻炼口语发音能力，让听英语并且跟读英语成为生活中的一部分。</p><p>打卡时间：2020年6月1日-6月23日（共21天）</p><p>其中休息日：6月6日、6月7日</p><p>打卡任务：坚持21天英语打卡学习，并且分享至朋友圈</p><p>分享格式：麦麦教育0基础21天英语打卡+学生名字 +第X天 +坚持就是胜利！</p><p>打卡奖励：</p><p>①坚持完成“21天打卡”的宝贝可以获得精美小礼品！</p><p>②每天分享打卡任务到朋友圈的小宝贝，还可以获得一份大礼包哦~</p><p>老师有话说：小宝贝每天只可完成1个打卡任务，做到真正吃透后再进行下一个任务哦。</p>';
export const DEFAULT_PASS_TEXT = '<p>亲爱的同学：</p><p>欢迎参加《麦麦芭蕾形体初级课打卡活动》，我们将通过芭蕾的几个特性如开、绷、直等，使身体各部位发展均衡，宝贝们每天需学完当前课时并完成打卡，才能解锁下一个课时内容</p><p>打卡时间：2020年6月1日-6月21日（共21天）</p><p>关卡数：共15关</p><p>每日可解锁上限：2关</p><p>打卡任务：坚持初级课闯关打卡课程，并且分享至朋友圈</p><p>分享格式：麦麦芭蕾0基础形体课打卡+学生名字 +第X关 +坚持就是胜利！</p><p>打卡奖励：</p><p>①坚持完成“闯关打卡”的宝贝可以获得精美小礼品！</p><p>②每关都分享打卡任务到朋友圈的小宝贝，还可以获得一份大礼包哦~</p><p>老师有话说：小宝贝每天最多完成2个任务，做到真正吃透后再进行下一个任务哦</p>';

export const NUM_TO_WORD_MAP = ['A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
// 日历打卡
export const CALENDAR_CLOCK = 'CALENDAR_CLOCK';
// 闯关打卡
export const PASS_GATE = 'PASS_GATE';

// 答题模式
export const ANSWER_THE_QUESTION = 'ANSWER_THE_QUESTION'
// 普通模式
export const ORDINARY = 'ORDINARY';

// 学生类型
export const STUDENT_TYPE = {
  NORMAL: '在读学员',
  POTENTIAL: '潜在学员',
  HISTORY: '历史学员'
}

// 打卡情况
export const CLOCK_STATUS = {
  CLOCKED: '已打卡',
  NO_CLOCK: '未打卡',
  NO_DATA: '从未打卡'
}

// 日签下载状况
export const DOWNLOAD_DAY_SIGN_STATUS = {
  DOWNED: '已下载',
  NO_DOWN: '未下载',
}

// 作业排序
export const ORDER_RULE_ENUM = [{
    key: 'DEFAULT',
    label: '默认排序'
  },
  {
    key: 'SCORE',
    label: '得分由高到低'
  },
  {
    key: 'BE_LIKE_NUM',
    label: '点赞数由高到低'
  }
]

export const QUESTION_TYPE_MAP = [{
    type: 'THE_RADIO',
    title: '单选题',
    componentType: 'Radio',
    key: 'THE_RADIO',
    icon: <React.Fragment>&#xe773;</React.Fragment>,
  },
  {
    type: 'MULTI_SELECT',
    title: '多选题',
    componentType: 'Checkbox',
    key: 'MULTI_SELECT',
    icon: <React.Fragment>&#xe775;</React.Fragment>,
  },
  {
    type: 'JUDGE',
    title: '判断题',
    componentType: 'Radio',
    key: 'JUDGE',
    icon: <React.Fragment>&#xe7bb;</React.Fragment>,
  }
]

export const MODULE_MEDIA_MAP = [{
  title: '文字',
  icon: <React.Fragment>&#xe760;</React.Fragment>,
  key: 'TEXT',
},
{
  title: '图片',
  icon: <React.Fragment>&#xe6ac;</React.Fragment>,
  key: 'PICTURE',
},
{
  title: '音频',
  icon: <React.Fragment>&#xe75f;</React.Fragment>,
  key: 'VOICE',
},
{
  title: '视频',
  icon: <React.Fragment>&#xe75e;</React.Fragment>,
  key: 'VIDEO',
},
{
  title: '文件',
  icon: <React.Fragment>&#xe759;</React.Fragment>,
  key: 'FILE',
}]

export const FILE_ACCEPT = {
  PICTURE: 'image/jpg,image/jpeg,image/png,image/bmp,image/gif',
  VIDEO: 'audio/mp4,video/mp4',
  VOICE: 'audio/x-mpeg,audio/mp3,audio/mpeg,audio/wav,audio/x-m4a'
}

export const QUESTION_FILE_ACCEPT = {
  PICTURE: 'image/jpg,image/jpeg,image/png,image/gif',
  VIDEO: 'audio/mp4,video/mp4',
  VOICE: 'audio/x-mpeg,audio/mp3,audio/mpeg'
}

export const MODE_ENUM_MAP = {
  general: {
    title: '普通模式',
    enumType: 'ORDINARY',
    example: [{
      title: '普通模式',
      img: 'https://image.xiaomaiketang.com/xm/jSQGeQQdkN.png'
    }]
  },
  answer: {
    title: '答题模式',
    enumType: 'ANSWER_THE_QUESTION',
    example: [{
      title: '答题模式-答题首页',
      img: 'https://image.xiaomaiketang.com/xm/Qb8WaDaNCM.png'
    }, {
      title: '答题模式-答题页',
      img: 'https://image.xiaomaiketang.com/xm/ERkGNsRP4G.png'
    }, {
      title: '答题模式-答题报告',
      img: 'https://image.xiaomaiketang.com/xm/HGyPthnCJx.png'
    }]
  }
}

export const MODE_MAP = [{
  img: 'https://image.xiaomaiketang.com/xm/S6YYwZwitP.png',
  title: '普通模式',
  desc: '每一个任务内可加入文本、图片、音频、视频等内容，学员查看任务要求后直接提交打卡',
  modeKey: 'general',
  enumType: 'ORDINARY',
}, {
  img: 'https://image.xiaomaiketang.com/xm/hPPwp8F2zT.png',
  title: '答题模式',
  desc: '可添加单选、多选、判断等类型题目，学生提交后系统将自动评分',
  modeKey: 'answer',
  enumType: 'ANSWER_THE_QUESTION',
}]

export const TRUE_OR_FALSE_MAP = [{
    value: 'RIGHT_OR_WRONG',
    label: ['对', '错']
  },
  {
    value: 'T_F',
    label: ['T', 'F'],
    alias: ['True', 'False']
  },
  {
    value: 'TICK',
    label: ['✓', '×']
  }
]

export const TRUE_OR_FALSE_KEY_MAP = {
  RIGHT_OR_WRONG: ['对', '错'],
  T_F: ['T', 'F'],
  TICK: ['✓', '×']
}

export const MEDIA_DESC_MAP = {
  VIDEO: '[视频]',
  VOICE: '[音频]',
  PICTURE: '[图片]'
}
