/*
 * @Author: yuananting
 * @Date: 2021-02-25 13:46:35
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-13 20:12:14
 * @Description: 助学工具-题库-题目管理-新增题目
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { Component } from "react";
import { Tabs, Button, Tooltip } from "antd";
import Breadcrumbs from "@/components/Breadcrumbs";
import ShowTips from "@/components/ShowTips";
import "./AddNewQuestion.less";
import NewQuestionTab from "./components/NewQuestionTab";
import { defineQuestionInfo } from "./components/model";
import QuestionBankService from "@/domains/question-bank-domain/QuestionBankService";
import User from "@/common/js/user";

const { TabPane } = Tabs;
class AddNewQuestion extends Component {
  constructor(props) {
    super(props);
    this.state = {
      activeKey: "SINGLE_CHOICE",
      // 构建题目基本结构
      singleChoiceContent: defineQuestionInfo("SINGLE_CHOICE"), // 单选题
      multiChoiceContent: defineQuestionInfo("MULTI_CHOICE"), // 多选题
      judgeContent: defineQuestionInfo("JUDGE"), // 判断题
      gapFillingContent: defineQuestionInfo("GAP_FILLING"), // 填空题
      indefiniteChoiceContent: defineQuestionInfo("INDEFINITE_CHOICE"), // 不定项选择题
    };
  }

  componentDidMount() {}

  saveCurrentQuestion = (content) => {
    content.questionStemList.map((item, index)=> {
      item.sort = index;
      return item;
    })
    content.optionList.map((item)=> {
      item.questionOptionContentList.map((childItem, childIndex) => {
        childItem.sort = childIndex;
        return childItem;
      })
      return item;
    })
    content.questionAnswerDescList.map((item, index)=> {
      item.sort = index;
      return item;
    })
    let params = {
      ...content,
      categoryId: getParameterByName("categoryId"),
      source: 0,
      tenantId: User.getStoreId(),
      userId: User.getUserId(),
    };
    QuestionBankService.addQuestion(params).then((res) => {
      console.log(res);
    });
  };

  confirmSaveQuestion = () => {
    const {
      singleChoiceContent,
      multiChoiceContent,
      judgeContent,
      gapFillingContent,
      indefiniteChoiceContent,
    } = this.state;
    switch (this.state.activeKey) {
      case "SINGLE_CHOICE":
        if (this.singleRef.checkInput() === 0) {
          this.saveCurrentQuestion(singleChoiceContent);
        }
        break;
      case "MULTI_CHOICE":
        this.multipleRef.checkInput();
        break;
      case "JUDGE":
        this.judgeRef.checkInput();
        break;
      case "GAP_FILLING":
        this.CompletionRef.checkInput();
        break;
      case "INDEFINITE_CHOICE":
        this.indefiniteRef.checkInput();
        break;
    }
  };

  render() {
    const {
      activeKey,
      singleContent,
      multipleContent,
      judgeContent1,
      completionContent,
      indefiniteContent,
      singleChoiceContent,
      multiChoiceContent,
      judgeContent,
      gapFillingContent,
      indefiniteChoiceContent,
    } = this.state;
    return (
      <div className="page add-new-question">
        <Breadcrumbs navList="新增题目" goBack={() => RCHistory.goBack()} />
        <div className="box">
          <div className="show-tips">
            <ShowTips message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" />
          </div>
          <Tabs
            style={{ marginTop: 32 }}
            activeKey={activeKey}
            onChange={(activeKey) => {
              this.setState({ activeKey });
            }}
          >
            <TabPane
              tab={<span className="icon iconfont">&#xe7fa; 单选题</span>}
              key="SINGLE_CHOICE"
            >
              <NewQuestionTab
                questionTypeKey="SINGLE_CHOICE"
                onRef={(ref) => {
                  this.singleRef = ref;
                }}
                questionInfo={singleChoiceContent}
                onSetState={(newContent) => {
                  console.log(newContent);
                  Object.assign(singleChoiceContent, newContent);
                }}
              />
            </TabPane>
            <TabPane
              tab={<span className="icon iconfont">&#xe7fb; 多选题</span>}
              key="MULTI_CHOICE"
            >
              <NewQuestionTab
                questionTypeKey="MULTI_CHOICE"
                onRef={(ref) => {
                  this.multipleRef = ref;
                }}
                questionInfo={multiChoiceContent}
                onSetState={(newContent) => {
                  Object.assign(multiChoiceContent, newContent);
                }}
              />
            </TabPane>
            <TabPane
              tab={<span className="icon iconfont">&#xe7fc; 判断题</span>}
              key="JUDGE"
            >
              <NewQuestionTab
                questionTypeKey="JUDGE"
                onRef={(ref) => {
                  this.judgeRef = ref;
                }}
                questionInfo={judgeContent}
                onSetState={(newContent) => {
                  Object.assign(judgeContent, newContent);
                }}
              />
            </TabPane>
            <TabPane
              tab={<span className="icon iconfont">&#xe7fd; 填空题</span>}
              key="GAP_FILLING"
            >
              <NewQuestionTab
                questionTypeKey="GAP_FILLING"
                onRef={(ref) => {
                  this.CompletionRef = ref;
                }}
                questionInfo={gapFillingContent}
                onSetState={(newContent) => {
                  Object.assign(gapFillingContent, newContent);
                }}
              />
            </TabPane>
            <TabPane
              tab={
                <span className="icon iconfont">
                  &#xe7fe; 不定项选择题{" "}
                  <Tooltip title="至少有一项正确，至多不限的选择题，多项选择题的一种特殊形式">
                    <span style={{ color: "#BFBFBF" }}>&#xe7c4;</span>
                  </Tooltip>
                </span>
              }
              key="INDEFINITE_CHOICE"
            >
              <NewQuestionTab
                questionTypeKey="INDEFINITE_CHOICE"
                onRef={(ref) => {
                  this.indefiniteRef = ref;
                }}
                questionInfo={indefiniteChoiceContent}
                onSetState={(newContent) => {
                  Object.assign(indefiniteChoiceContent, newContent);
                }}
              />
            </TabPane>
          </Tabs>
        </div>
        <div className="footer">
          <Button>取消</Button>
          <Button>保存并继续添加</Button>
          <Button
            type="primary"
            onClick={() => {
              this.confirmSaveQuestion();
            }}
          >
            保存
          </Button>
        </div>
      </div>
    );
  }
}

export default AddNewQuestion;
