/*
 * @Author: yuananting
 * @Date: 2021-02-21 17:51:01
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-13 16:48:23
 * @Description: 助学工具-题库-题库主页面
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { Component } from "react";
import "./QuestionBankIndex.less";
import QuestionBankSider from "./components/QuestionBankSider";
import QuestionManageList from "./components/QuestionManageContent";
import User from "@/common/js/user";
import QuestionBankService from "@/domains/question-bank-domain/QuestionBankService";

class QuestionBankIndex extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedCategoryId: "",
      loading: true,
      dataSource: [], // 题库列表数据
      totalCount: 1, // 题库数据总条数
    };
  }

  componentDidMount() {
    // TODO
    // 接口请求 初始化数据
  }

  getCategoryIdFromSider = (selectedCategoryId) => {
    if (selectedCategoryId && selectedCategoryId.length > 0) {
      this.setState({ selectedCategoryId: selectedCategoryId[0] });
    }
  };

  render() {
    return (
      <div className="question-bank-index page">
        <div className="content-header">题目</div>
        <div className="box content-body">
          <div className="sider">
            <QuestionBankSider
              getSelectedCategoryId={this.getCategoryIdFromSider.bind(this)}
            />
          </div>
          <div className="content">
            <QuestionManageList selectedCategoryId={this.state.selectedCategoryId} />
          </div>
        </div>
      </div>
    );
  }
}

export default QuestionBankIndex;
