import React, {  useEffect, useState} from "react";
import { Modal, Button, InputNumber  } from 'antd';
import "./BatchScore.less"
import _ from "underscore";

interface Rule {
    typeKey: "SINGLE_CHOICE"|"MULTI_CHOICE"| "JUDGE"|"GAP_FILLING"|"INDEFINITE_CHOICE",
    score: number,
    portionScore: number,
    totalQuestion: number,
}

interface BatchScoreProps {
    visible:boolean,
    rules: Rule[],
    onOK: (rules:Rule[]) => void,
    onCancel: () => void,
}

export default function BatchScore(props:BatchScoreProps) {
    
    const [rules, setRules] = useState<Rule[]>(props.rules)
    const [singleCount, setSingleCount] = useState<number[]>([0])
    const [multiCount, setMultiCount] = useState<number[]>([0])
    const [judgeCount, setJudgeCount] = useState<number[]>([0])
    const [gapCount, setgapCount] = useState<number[]>([0])
    const [indefiniteCount, setIndefiniteCount] = useState<number[]>([0])

    useEffect(()=> {
        _.map(props.rules,(item)=> {
            switch(item.typeKey) {
              case "SINGLE_CHOICE":
                setSingleCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "MULTI_CHOICE":
                setMultiCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "JUDGE":
                setJudgeCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "GAP_FILLING":
                setgapCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "INDEFINITE_CHOICE":
                setIndefiniteCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              default:
                break;
            }
        })
        console.log("KKKKKKKKKKKKKKK")
    },[rules])

    if (!props.visible) {
        return ("")
    }

    function onOk() {
        props.onOK(rules)
    }

    function onCancel() {
        props.onCancel()
    }

    const inputNumberStyle = {width:"57px",margin:"0 8px"}
    return (
        <Modal 
        className="batchscore"
        title="批量设置分数"
        onCancel={onCancel}
        onOk={onOk}
        visible={props.visible}
        maskClosable={false}
        width={660}
        >
            <div className="content">
            <div className="item">
                <span className="type">【单选题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                defaultValue={_.find(rules,(it)=>{return it.typeKey === "SINGLE_CHOICE"})?.score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "SINGLE_CHOICE") {
                            item.score = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{singleCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{singleCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【多选题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                defaultValue={_.find(rules,(it)=>{return it.typeKey === "MULTI_CHOICE"})?.score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "MULTI_CHOICE") {
                            item.score = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分，漏选得
                <InputNumber 
                min={0} 
                defaultValue={1} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "MULTI_CHOICE") {
                            item.portionScore = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{multiCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{multiCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【不定项选择题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                defaultValue={_.find(rules,(it)=>{return it.typeKey === "INDEFINITE_CHOICE"})?.score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "INDEFINITE_CHOICE") {
                            item.score = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分，漏选得
                <InputNumber 
                min={0} 
                defaultValue={1} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "INDEFINITE_CHOICE") {
                            item.portionScore = Number(v)
                        }
                        return item
                    }))
                }}
                />分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{judgeCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{judgeCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【判断题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                defaultValue={_.find(rules,(it)=>{return it.typeKey === "JUDGE"})?.score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "JUDGE") {
                            item.score = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{indefiniteCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{indefiniteCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【填空题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                defaultValue={_.find(rules,(it)=>{return it.typeKey === "GAP_FILLING"})?.score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "GAP_FILLING") {
                            item.score = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分，半对得<InputNumber 
                min={0} 
                defaultValue={1} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    setRules(_.map(rules,(item)=>{
                        if (item.typeKey === "GAP_FILLING") {
                            item.portionScore = Number(v)
                        }
                        return item
                    }))
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{gapCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{gapCount[1]}</span>分</span>
            </div>
            </div>

        </Modal>
    )
}