import React from 'react';
import { Modal, TreeSelect } from 'antd';
import './MoveModal.less';

class MoveModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      categoryId: undefined,
    };
  }

  handleChangeCatalogList = (value, label) => {
    this.setState({ categoryId: value, categoryName: label[0] });
  };

  filterData = (data, id) => {
    let newTreeData = data.map((item) => {
      item.disabled = id === item.id;
      if (item.children) {
        item.children = this.filterData(item.children, id);
      }
      return item;
    });
    return newTreeData;
  }

  render() {
    const { visible, title, onCancel, onOk, data, length, categoryId: id } = this.props;
    const { categoryId } = this.state;
    const moveData = this.filterData(data, id);
    return (
        <Modal
          title={`移动${title}`}
          visible={visible}
          onCancel={onCancel}
          maskClosable={false}
          className="common-move-modal"
          onOk={() => onOk(categoryId)}
        >
          <div className="tip">
            <span className="icon iconfont">&#xe6f2;</span>
            <span className="text">已选择<span style={{ color: '#2966FF' }}>{length}</span>个{title}，移动后，原有分类将移除此{title}。</span>
          </div>
          <div className="move-item">
            <span className="label">选择分类：</span>
            <TreeSelect
              showSearch
              treeNodeFilterProp="title"
              style={{ width: 240 }}
              dropdownStyle={{ maxHeight: 220 }}
              treeData={moveData}
              placeholder="请选择分类"
              allowClear
              value={categoryId}
              onChange={(value, label) => {
                this.handleChangeCatalogList(value, label);
              }}
            />
          </div>
        </Modal>
    )
  }
}

export default MoveModal;