import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { XMTable,PageControl} from '@/components';
import college from '@/common/lottie/college.json';
import "./UserTable.less";

function UserTable() {
    const [courseList,setCourseList] = useState([]);
    const [total, setTotal] = useState(0);
    const [query, setQuery] = useState({
        current: 0,
        size: 10,
    });
    const columns = [
        {
        title: '学员',
        dataIndex: 'user',
        width:220,
        render: (val, record) => {
            return <span>{val}</span>
        }
        },
        {
        title: '真实姓名',
        dataIndex: 'nickname',
        width:'15%',
        render: (val,record) => {
            return  <span>{val}</span>
            
        }
        },
        {
        title: '账号',
        dataIndex: 'account',
        width:'15%',
        render: (val,record) => {
            return <span>{val}</span>
        }
        },
        {
        title: '岗位',
        dataIndex: 'post',
        render: (val, record) => {
            return <span>{val}</span>
        }
        },
        {
        title: '手机号',
        dataIndex: 'phone',
        render: (val, record) => {
            return <span>{val}</span>;
        }
        },
        {
        title: '注册时间',
        dataIndex: 'registerTime',
        render: (val, record) => {
            return <span>{val}</span>;
        }
        },
        {
        title: "操作",
        key: "operate",
        dataIndex: "operate",
        render: (val, record) => {
            return (
            <div className="operate">
                <div
                className="operate__item"
                >
                删除
                </div>
            </div>
            )
        }
        },
    ];
    return (
        <div className="user-table">
            <XMTable
                renderEmpty={{
                image: college,
                description: '暂无数据',
                }}
                bordered
                size='middle'
                pagination={false}
                columns={columns}
                scroll={{ x: 1300 }}
                dataSource={courseList}
            />
            <div className='box-footer'>
                <PageControl
                    current={query.current}
                    pageSize={query.size}
                    total={total}
                    toPage={(page) => {
                    const queryStates = _.clone(query);
                    queryStates.current = page;
                    setQuery(queryStates);
                    }}
                />
            </div>
        </div>
    );
}

export default withRouter(UserTable);