import React from 'react';
import Service from '@/common/js/service';
import { DISK_MAP } from '@/domains/resource-disk/constants';
import FolderManage from './components/FolderManage';
import DiskList from './components/DiskList';
import './index.less';


const defaultRootDisk = {
  folderName: '公共文件',
  disk: 'COMMON',
  uploadPower: true
}

class PrepareLessonPage extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      // 目前只有公共文件，先由前端定义
      diskList: [
        {
          folderName: '公共文件',
          disk: 'COMMON',
          uploadPower: true
        }
      ],                   // 可见磁盘目录
      currentRootDisk: defaultRootDisk
    }
  }

  handleChangeDisk = (disk) => {
    this.setState({
      currentRootDisk: disk
    });
  }

  render() {
    const { currentRootDisk, diskList } = this.state;
    console.log('currentRootDisk',currentRootDisk);
    return (
      <div className="prepare-lesson-page page">
        <div className="content-header">资料云盘</div>
        <div className="box content-body">
          <DiskList
            diskList={diskList}
            currentRootDisk={currentRootDisk}
            onChange={this.handleChangeDisk}
          />
          <FolderManage
            currentRootDisk={currentRootDisk}
          />
        </div>
      </div>
    )
  }
}

export default PrepareLessonPage;