/*
 * @Author: 吴文洁
 * @Date: 2019-07-10 10:30:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-22 15:39:28
 * @Description:
 */
import React, { useContext, useEffect, useState } from 'react';
import { withRouter} from 'react-router-dom';
import {ConfigProvider } from 'antd';
import Header from './Header'
import Menu from './Menu'
import Main from './Main'
import zhCN from 'antd/es/locale/zh_CN'
import User from '@/common/js/user';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import { setStoreGroupPermission, setStorePermission, setStoreGroupList, setStoreList } from '@/store/actions/index';
declare var window: any;

const App: React.FC = (props: any) => {
  const ctx: any = useContext(XMContext);
  const userId = User.getUserId();
  window.currentUserInstInfo = {adminId: "1305385165390426114", adminName: "吴帆", gender: "UNKNOWN", parentId: "1305385165390426114", roleRemark: "", instId: "1213001850820476929" }
  const [menuType,setMenuType]=useState(true);
  window.ctx = ctx;

  
  useEffect(() => {
    getStoreAndUserInfo();
  },[userId])

  async function getStoreAndUserInfo(){
    await getStoreGroupAndStoreList();
  }

  function getStoreGroupAndStoreList() {
    
    BaseService.getUserStore({ userId }).then((res) => {
      
      const { storeGroupVOS = [], storeVOS = [] } = res.result;
      const { id, storeUserId,storeName } = storeVOS[0];

      User.setStoreId(id);
      User.setStoreUserId(storeUserId);
      User.setStoreName(storeName);
      ctx.dispatch(setStoreGroupList(storeGroupVOS))
      ctx.dispatch(setStoreList(storeVOS));
      
      getUserPermission();
    });
  }

  function getUserPermission() {
    BaseService.getUserPermission({  }).then((res) => {
      console.log(res.result);
      const {storePermission, storePermissionGroup, storeUserPermission, storeUserPermissionGroup } = res.result;
      ctx.dispatch(setStoreGroupPermission(storePermissionGroup))
      ctx.dispatch(setStorePermission(storeUserPermissionGroup))
    });
  } 
  function handleMenuType(){
    setMenuType(!menuType);
  }
    return (
      <div id="home">
        <Header handleMenuType={handleMenuType} menuType={menuType}/>
        <ConfigProvider locale={zhCN} >
          <Main menuType={menuType}/>
        </ConfigProvider>
        <Menu menuType={menuType}/>
      </div>
    )
}

export default withRouter(App)
