/*
 * @Author: 吴文洁
 * @Date: 2020-10-10 18:19:34
 * @LastEditors: 吴文洁
 * @LastEditTime: 2020-10-13 18:09:39
 * @Description: 
 * @Copyright: 杭州杰竞科技有限公司 版权所有
 */
import OSS from 'ali-oss';
import { UPLOAD_REGION } from '@/domains/resource-disk/constants';
import { getOssClient } from '@/data-source/basic/basic-apis';

interface IMultiPartUpload {
  data: object;
  instId: string;
  bizCode: string;
  resourceName: string;
  accessTypeEnum: string;
}

export default class UploadFileService {

  static getOssClient(multiPartUploadParams: IMultiPartUpload) {
    const { data, instId, bizCode, resourceName, accessTypeEnum } = multiPartUploadParams;
    return new Promise(resolve => {
      getOssClient(
        data,
        instId,
        bizCode,
        resourceName,
        accessTypeEnum
      ).then((res) => {
        const { result = {} } = res;
        const {
          bucket,
          callBack,
          resourceId,
          accessKeyId,
          securityToken,
          accessKeySecret,
          callbackBody,
          ossUri
        } = result;
        
        const ossClient = new OSS({
          bucket,
          accessKeyId,
          accessKeySecret,
          region: UPLOAD_REGION,
          stsToken: securityToken,
        });

        resolve({
          ossClient,
          resourceId,
          callBack,
          callbackBody,
          ossUri
        });
      })
    })
  }
}