import React from 'react'

import OfflineCourseFilter from './components/OfflineCourseFilter'
import OfflineCourseOpt from './components/OfflineCourseOpt'
import OfflineCourseList from './components/OfflineCourseList'
import Service from '@/common/js/service'
import User from '@/common/js/user'

class OfflineCoursePage extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      query: {
        size: 10,
        current: 1,
        storeId: User.getStoreId(),
      },
      dataSource: [], // 线下课列表
      totalCount: 0, // 线下课数据总条数
    }
  }

  componentWillMount() {
    // 获取线下课列表
    this.handleFetchScheduleList()
  }

  // 获取线下课列表
  handleFetchScheduleList = (_query = {}) => {
    const query = {
      ...this.state.query,
      ..._query,
    }

    // 更新请求参数
    this.setState({ query })
    Service.Hades('public/hades/getOfflineCoursePage', query).then((res) => {
      const { result = {} } = res || {}
      const { records = [], total = 0 } = result
      this.setState({
        dataSource: records,
        totalCount: Number(total),
      })
    })
  }

  render() {
    const { dataSource, totalCount, query } = this.state
    return (
      <div className='page video-course-page'>
        <div className='content-header'>线下活动</div>

        <div className='box'>
          {/* 搜索模块 */}
          <OfflineCourseFilter onChange={this.handleFetchScheduleList} />

          {/* 操作模块 */}
          {window.ctx.xmState.storeUserPermissionList.includes('AddOfflineClass') && <OfflineCourseOpt />}

          {/* 线下课列表模块 */}
          <OfflineCourseList query={query} dataSource={dataSource} totalCount={totalCount} onChange={this.handleFetchScheduleList} />
        </div>
      </div>
    )
  }
}

export default OfflineCoursePage
