/*
 * @Description: 计费说明
 * @Author: zhangyi
 * @Date: 2020-05-09 15:21:22
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-22 20:30:54
 */
import React from 'react'
import { Modal, Button, Table } from "antd";
import "./AccountChargeModal";
const data = [
  { person: "上台人数1v1", price: "3元/人/小时" },
  { person: "上台人数1v2", price: "3元/人/小时" },
  { person: "上台人数1v3", price: "3元/人/小时" },
  { person: "上台人数1v4", price: "3元/人/小时" },
  { person: "上台人数1v5", price: "3元/人/小时" },
  { person: "上台人数1v6", price: "3元/人/小时" },
  { person: "上台人数1v7", price: "4元/人/小时" },
  { person: "上台人数1v8", price: "4元/人/小时" },
  { person: "上台人数1v9", price: "8元/人/小时" },
  { person: "上台人数1v10", price: "8元/人/小时" },
  { person: "上台人数1v11", price: "8元/人/小时" },
  { person: "上台人数1v12", price: "8元/人/小时" },
];

function ChargeExplainModal(props) {
  return (
    <Modal
      title="计费说明"
      visible={true}
      className="charge-explain-modal"
      width={880}
      maskClosable={false}
      closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
      onCancel={() => {
        props.close();
      }}
      footer={[
        <Button
          type="primary"
          onClick={() => {
            props.close();
          }}
        >
          关闭
        </Button>,
      ]}
    >
      <div>
        <div className="explain-title">1）直播课时费</div>
        <p className="main-explain-block">
        每节课上课费用 = 上台人数单价 × 有效出勤学生和老师人数 × 排课时长 
        </p>

        <ul>
          <li>
            1. 上课老师、学生和助教在教室中的累计时长满10分钟即为有效出勤；
          </li>
          <li>
            2.
            排课时长指创建课节设置的课节时长，最小计费单位为0.5小时，不足0.5小时按0.5小时计算；
          </li>
          <li>
            3.
            上台人数单价：以排课时设定的上台人数上限为准，不同直播教室类型的课时单价不同。
          </li>
        </ul>
        <p className="main-explain-text" style={{marginTop: 16,marginBottom: 8}}>
          温馨提醒：上台人数1vN，1为授课老师，N为同时与老师视频互动学生数；直播课时费将在老师下课后立即结算。
        </p>
        <table style={{ width: 333 }}>
          <thead>
            <tr>
              <th>上台人数</th>
              <th>价格标准</th>
            </tr>
          </thead>
          <tbody>
            {data.map((item) => {
              return (
                <tr>
                  <td>{item.person}</td>
                  <td>{item.price}</td>
                </tr>
              );
            })}
          </tbody>
        </table>

        <p className="main-explain-text">
          示例：王老师排了一节45分钟的课程，选择的直播教室类型为5人上台，安排了1位助教、12位学生。那么，排课时长45分钟记为1小时；全员累计在线时长≥10min，老师+助教+学生共计1+1+12=14人；课时单价3元/人/小时。所以，此节课的直播课时费=1x14x3=42元
        </p>
        <div className="explain-title mt16">2）录制费</div>
        <p className="main-explain-block">录制费 = 录课单价 × 回放视频时长</p>

        <ul>
          <li>1. 结算时间：从回放视频生成后立即结算</li>
          <li> 2. 回放视频时长：0.5h起收，不足0.5h的按0.5h结算</li>
          <li> 3. 单价：2元/小时</li>
        </ul>
        <p className="main-explain-text">
          示例：生成了49分26秒的回放视频，不足1h按1h计算，总费用=1(h)*2元/h=2元
        </p>
        <div className="explain-title mt16">3）流量费</div>
        <p className="main-explain-block">
          观看回放视频流量费 = 流量单价 × 回放流量
        </p>
        <p className="main-explain-text">
          目前收费报价：0元（限时免费）
          <br /> 若后续变更收费，将提前30日通告收费方式及价格标准
        </p>
        <div className="explain-title mt16">4）存储费</div>
        <p className="main-explain-block">存储实际扣费 = 存储单价 × 存储文件大小</p>
        <p className="main-explain-text">
          目前收费报价：0元（限时免费）
          <br />
          若后续变更收费，将提前30日通告收费方式及价格标准
        </p>
        <div className="explain-title mt16">5）其他说明</div>
        <div className="main-explain-text">
          余额不足时将限制使用创建直播课、老师和学生进入直播间、老师和学生观看回放视频、在资料云盘或直播间上传文件等功能，请注意及时充值。（余额＜300元时将发送短信提醒，请注意查看。）
        </div>
      </div>
    </Modal>
  );
}

export default ChargeExplainModal;
