/*
 * @Author: yuananting
 * @Date: 2021-08-05 10:55:49
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-12 19:23:56
 * @Description: 个人学习详情
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useEffect, useState } from 'react';
import { Tabs } from 'antd';
import Breadcrumbs from '@/components/Breadcrumbs';
import WholeData from './components/WholeData';
import { withRouter } from 'react-router-dom';
import TestLinkTaskData from './components/TestLinkTaskData';
import CustomerLearnBasicInfo from './components/CustomerLearnBasicInfo';
import User from '@/common/js/user';
import TaskCenterService from '@/domains/task-center-domain/TaskCenterService';

import './UserLearningData.less';

const { TabPane } = Tabs;

function UserLearningData(props) {
  const taskId = props.taskId;
  const storeCustomerId = props.match.params.storeCustomerId.replace(/\?.+/, '');
  const tabList = [
    {
      name: '全部',
      key: 'whole',
      compoment: WholeData,
    },
    {
      name: '考试',
      key: 'exam',
      compoment: TestLinkTaskData, // todo
    },
  ];
  const [detail, setDetail] = useState({});

  useEffect(() => {
    getTaskCustomerDetail();
  }, []);

  function getTaskCustomerDetail() {
    const params = {
      storeCustomerId,
      storeId: User.getStoreId(),
      taskId,
    };
    TaskCenterService.getTaskCustomerDetail(params).then((res) => {
      const { result = {} } = res;
      setDetail(result);
    });
  }

  return (
    <div className='page user-learning-data'>
      <Breadcrumbs
        navList='学员学习数据'
        goBack={() => {
          props.history.goBack();
        }}
      />
      <CustomerLearnBasicInfo detail={detail} />
      <div className='gap-line'></div>
      <div className='content'>
        <Tabs defaultActiveKey={'whole'} onChange={() => {}}>
          {tabList.map((item) => {
            return (
              <TabPane tab={item.name} key={item.key}>
                {<item.compoment detail={detail} />}
              </TabPane>
            );
          })}
        </Tabs>
      </div>
    </div>
  );
}

export default withRouter(UserLearningData);
