import React from 'react';
import { withRouter } from 'react-router-dom';
import { Form, Input, Button, Modal,Switch, message } from 'antd';
import SelectPrepareFileModal from '@/modules/prepare-lesson/modal/SelectPrepareFileModal';
import Upload from '@/core/upload';
import StoreService from '@/domains/store-domain/storeService';
import User from '@/common/js/user';
import Bus from '@/core/tbus';
import ImgClipModal from '@/components/ImgClipModal';
import './CollegeInfoPage.less';
class CollegeInfoPage extends React.Component {
  formRef = React.createRef();
  constructor(props) {
    super(props);
    this.state = {
      storeName: null,
      logo: '',
      showSelectFileModal: false,
      cutImageBlob: null,
      imageFile: null, // 需要被截取的图片
      auditSwitch:"OPEN",
      videwMoal:false
    };
  }
  componentWillMount() {
    if (User.getEnterpriseId()) {
      this.getStoreDetail();
    } else {
      window.RCHistory.replace('/store-info');
    }
  }
  getStoreDetail = () => {
    const params = {
      storeId: User.getStoreId(),
    };
    StoreService.getStoreDetail(params).then((res) => {
      const { result = {} } = res;
      const { storeName, logo,auditSwitch } = result;
      this.formRef.current.setFieldsValue({
        storeName: storeName,
      });
      this.setState({
        storeName,
        auditSwitch,
        logo,
      });
    });
  };
  
  onChangeFiledValue = (filed, value) => {
    console.log(filed, value)
    this.setState({
      [filed]: value,
    });
  };


  handleSelectCover = (file) => {
    this.setState({
      visible: true,
      imageFile: file,
    });
  };

  //获取resourceId
  getSignature = (blob, fileName) => {
    Upload.uploadBlobToOSS(blob, 'cover' + new Date().valueOf(), null, 'signInfo').then((signInfo) => {
      this.setState(
        {
          coverClicpPath: signInfo.fileUrl,
          coverId: signInfo.resourceId,
          visible: false,
        },
        () => this.updateCover()
      );
    });
  };
  updateCover = () => {
    const { coverClicpPath, coverId } = this.state;
    this.setState({
      showSelectFileModal: false,
    });
    this.setState({
      logo: coverClicpPath,
    });
  };

  updateInfo = () => {
    const { storeName, logo, auditSwitch
    } = this.state;
    if (!storeName) {
      message.warning('请输入学院名称');
      return;
    }
    const params = {
      storeName,
      logo,
      storeId: User.getStoreId(),
      auditSwitch

    };
    StoreService.updateStoreMessage(params).then((res) => {
      User.setStoreName(storeName);
      Bus.trigger('storeNameChange', storeName);
      message.success('保存成功');
      Bus.trigger('updateCollegeInfo');
    });
  };
  renderModal (){
    const {videwMoal} = this.state
    return <Modal
    visible={videwMoal}
    title={'功能预览'}
    width={680}
    onCancel={()=>{this.setState({videwMoal:false})}}
    maskClosable={false}
    footer={null}
    closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
  >
    <div className='college-info-page-view-modal-box'>
      <img src='https://image.xiaomaiketang.com/xm/xRrsNKr8jn.gif' alt=''></img>
    </div>
  </Modal>
  }
  render() {
    const { storeName, showSelectFileModal, visible, logo, imageFile,auditSwitch } = this.state;
    return (
      <div className='page college-info-page'>
        <div className='content-header'>学院信息</div>
        <div className='box'>
          <div className='college-info-page-form'>
            <Form ref={this.formRef}>
              <div className='title'>基本信息</div>
              <Form.Item label='学院LOGO'>
                <div className='logo-con'>
                  <div className='logo-img-con'>
                    <Choose>
                      <When condition={logo}>
                      <img src={logo} className='logo-img' alt=''/>
                      </When>
                      <Otherwise>
                      <div className='logo-box'>
                        <span className='text'>Logo</span>
                      </div>
                      </Otherwise>
                    </Choose>
                  </div>
                  <div className='upload-box'>
                    <span
                      onClick={() => {
                        this.setState({ showSelectFileModal: true });
                      }}
                      className='upload-btn'>
                      <span>上传</span>
                    </span>
                    <div className='tip'>建议尺寸702*180px。最大2M，支持jpg、jpeg和png。</div>
                  </div>
                </div>
              </Form.Item>
              <Form.Item label='学院名称' name='storeName' rules={[{ required: true }]}>
                <Input
                  value={storeName}
                  style={{ width: '300px' }}
                  placeholder='请输入学院名称'
                  onChange={(e) => this.onChangeFiledValue('storeName', e.target.value)}
                  maxLength={30}
                />
              </Form.Item>
              <div className='title mt40'>高级设置</div>
              <Form.Item label='学员审核' name='storeName' rules={[{ required: true }]}>
                <div className='switch-box'>
                  <Switch checked={auditSwitch ==='OPEN' } onChange={(e) => this.onChangeFiledValue('auditSwitch', e ?'OPEN':'CLOSE')}/>
                  <Choose>
                    <When condition={auditSwitch ==='OPEN'}>
                      <div className='switch-desc'>已开启，成为学院学员需要审核</div>
                      <div className='switch-prew-link' onClick={()=>this.setState({videwMoal:true})}>功能预览</div>
                    </When>
                    <Otherwise>
                      <div className='switch-desc'>已关闭，成为学院学员不需要审核</div>
                    </Otherwise>
                  </Choose>
                </div>
              </Form.Item>
            </Form>
          </div>
          {showSelectFileModal && (
            <SelectPrepareFileModal
              key='basic'
              operateType='select'
              multiple={false}
              accept='image/jpeg,image/png,image/jpg'
              selectTypeList={['JPG', 'JPEG', 'PNG']}
              tooltip='支持文件类型：jpg、jpeg、png'
              isOpen={showSelectFileModal}
              onClose={() => {
                this.setState({
                  showSelectFileModal: false,
                });
              }}
              onSelect={this.handleSelectCover}
            />
          )}
          {visible && (
            <ImgClipModal
              visible={visible}
              imgUrl={imageFile.ossUrl}
              aspectRatio='125/32'
              cropBoxHeight='128'
              onConfirm={this.getSignature}
              onClose={() => {
                this.setState({ visible: false });
              }}
            />
          )}
          <div>
            <Button type='primary' onClick={this.updateInfo} htmlType='submit' className='submit-btn'>
              保存设置
            </Button>
          </div>
        </div>
        {this.renderModal()}
      </div>
    );
  }
}

export default withRouter(CollegeInfoPage);
