import React from 'react';

import { message, Badge } from 'antd';
import { PageControl, XMTable } from '@/components';

import WWOpenDataCom from '@/components/WWOpenDataCom';
import './WechatUserAuditList.less';
import StoreService from '@/domains/store-domain/storeService';
import User from '@/common/js/user';

function WechatUserAuditList(props) {
  const { listData, totalCount, query, onChange = () => {} } = props;

  function parseColumns() {
    const columns = [
      {
        title: '微信名称',
        key: 'nickName',
        dataIndex: 'nickName',
        width: '12%',
        fixed: 'left',
        render: (val, record) => {
          return <div className='wechat-user-audit-name'>{val}</div>;
        },
      },
      {
        title: '真实姓名',
        key: 'realName',
        dataIndex: 'realName',
        width: '12%',
        render: (val) => {
          return <div className='create-name'>{val}</div>;
        },
      },
      {
        title: '申请时间',
        width: '12.5%',
        key: 'applyDate',
        dataIndex: 'applyDate',
        render: (val) => {
          return <span style={{ whiteSpace: 'nowrap' }}>{window.formatDate('YYYY-MM-DD H:i', val)}</span>;
        },
      },
      {
        title: '审批状态',
        width: '10%',
        key: 'applyStatus',
        dataIndex: 'applyStatus',
        render: (val) => {
          return (
            <div className='valid-state-icon'>
              <Choose>
                <When condition={val === 'PASSED'}>
                  <Badge color='#0ACCA4' text='已通过' />
                </When>
                <When condition={val === 'REJECTED'}>
                  <Badge color='#EC4B35' text='已拒绝' />
                </When>
                <Otherwise>
                  <Badge color='#FFB714' text='待审核' />
                </Otherwise>
              </Choose>
            </div>
          );
        },
      },
      {
        title: '审核人',
        width: '10%',
        key: 'reviewer',
        dataIndex: 'reviewer',
        render: (val) => {
          return <div>
             <WWOpenDataCom type="userName" openid={val} />
          </div>;
        },
      },
      {
        title: '操作',
        key: 'operate',
        dataIndex: 'operate',
        fixed: 'right',
        width: '14.5%',
        render: (val, record) => {
          return (
            <Choose>
              <When condition={record.applyStatus === 'WAIT'}>
                <div className='operate'>
                  <div className='operate__item' onClick={() => audit(record, true)}>
                    通过
                  </div>
                  <span className='operate__item split'> | </span>
                  <div className='operate__item' onClick={() => audit(record, false)}>
                    拒绝
                  </div>
                </div>
              </When>
              <Otherwise>
                <div className='operate'>
                  <div></div>
                </div>
              </Otherwise>
            </Choose>
          );
        },
      },
    ];
    return columns;
  }

  function audit(record, isTrue) {
    const { id } = record;
    const params = {
      applyCustomerId: id,
      audit: isTrue,
      operatorId: User.getStoreUserId(),
      storeId: User.getStoreId(),
    };
    StoreService.auditOperation(params).then((res) => {
      if (res.success) {
        message.success('操作成功');
        onChange(query)
      }
    });
  }

  function onShowSizeChange(current, size) {
    if (current === size) {
      return;
    }
    let _query = query;
    _query.size = size;
    onChange(_query);
  }

  return (
    <div className='wechat-user-audit-list'>
      <XMTable
        rowKey={(record) => record.id}
        showSorterTooltip={false}
        dataSource={listData}
        columns={parseColumns()}
        pagination={false}
        bordered
        size='middle'
        scroll={{ x: 1400 }}
        className='wechat-user-audit-list-table'
        renderEmpty={{
          description: <span style={{ display: 'block', paddingBottom: 24 }}>暂无数据</span>,
        }}
      />
      <div className='box-footer'>
        <PageControl
          current={query.current - 1}
          pageSize={query.size}
          total={totalCount}
          toPage={(page) => {
            const _query = { ...query, current: page + 1 };
            onChange(_query);
          }}
          onShowSizeChange={onShowSizeChange}
        />
      </div>
    </div>
  );
}

export default WechatUserAuditList;
