import Platform from './platform';
import Service from "@/common/js/service";
import User from '@/common/js/user';

export default class WechatApi {
    static initShareConfig() {
        // if (Platform.isWeiXin()) {
        const data = { url: window.location.href.split('#')[0], storeId: User.getStoreId(), }
        Service.Hades('anon/hades/getWxWorkJSAPISignature', data).then((result) => {
            const res = result.result;
            const conf ={ 
                corpid: res.corpid, // 必填，企业微信的corpid，必须与当前登录的企业一致
                agentid: res.agentid, // 必填，企业微信的应用id （e.g. 1000247）
                timestamp: res.timestamp, // 必填，生成签名的时间戳
                nonceStr: res.nonceStr,// 必填，生成签名的随机串
                signature: res.signature,
                jsApiList: ['startLiving','downloadLivingReplay'],
                success: function(res) {
                    console.log('agentConfig注册成功')
                   console.log(res,'agentConfig')
                },
                fail: function(res) {
                    console.log(res,' agentConfig1 错误')
                    if(res.errMsg.indexOf('function not exist') > -1){
                        alert('版本过低请升级')
                    }
                },
                complete:(res)=>{
                    console.log(res,' agentConfig2 错误')
                }
            }
            console.log(conf)
            
            wx.agentConfig(conf);
        });
        // }
    }

}