import PropTypes from 'prop-types';
import { Form, Button, message, Switch, Input, Row, Col } from 'antd';
import {
  withRouter
} from 'react-router-dom';
import UpLoad from "../common/UpLoad";
import PasswordModal from './PasswordModal';
import './UserInfo.less';
import Bus from '../../core/bus';
import { HookContext } from '../../routes';

const FormItem = Form.Item;

class UserInfo extends BaseComponent {
  constructor(props) {
    super(props);
    this.state = {
      avatar: window.currentUserInstInfo.avatar || '',
      nickName: window.currentUserInstInfo.nickName || '',
      homeworkNotice: false,
      commentNotice: false,
      submitNotice: false,
      fileNotice: false,
    };
  }

  componentDidMount() {
    window.NewVersion ? this.newFetchMessageControl(): this.fetchMessageControl();
  }

  newFetchMessageControl() {
    axios.Business('public/config/getAdminConfigs').then((res) => {
      let data = {};
      _.map(res.result, (item) => {
        if (item.configType == 'HOMEWORK_REVERT') {
          data.homeworkNotice = item.configValue == 'TRUE';
        } else if (item.configType == 'ASSESSMENT_REVERT') {
          data.commentNotice = item.configValue == 'TRUE';
        } else if (item.configType == 'MI_PUSH_T_SUBMIT_HOMEWORK') {
          data.submitNotice = item.configValue == 'TRUE';
        } else if (item.configType == 'MI_PUSH_T_ARCHIVES_REVERT') {
          data.fileNotice = item.configValue == 'TRUE';
        }
      })
      this.setState(data);
    })
  }

  fetchMessageControl() {
    axios.post('api-b/b/inst/adminConfig').then((res) => {
      if (res.data) {
        try {
          const homeworkNotice = !!(_.find(res.data, (item) => {
            return item.code == '1';
          })).status;
          const commentNotice = !!(_.find(res.data, (item) => {
            return item.code == '2';
          })).status;
          this.setState({ homeworkNotice, commentNotice });
        } catch (error) {
          // this._disconnected(ERROR.INTERNAL_ERROR.code, format(ERROR.INTERNAL_ERROR, [error.message, error.stack.toString()]));
          // return;
        }
      }
    });
  }

  changeMessageControl(messageType, status) {
    window.NewVersion ?
      axios.Business('public/config/modifyAdminConfig', { configType: ENUM.adminConfig[messageType], configValue: status == 1 ? 'TRUE' : 'FALSE' }).then(() => {
        this.FetchMessageControl();
      })
      : axios.post('api-b/b/inst/edit/adminConfig', { messageType, status }).then(() => {
        this.fetchMessageControl();
      });
  }
  handleEditNickName = () => {
    // if (!this.state.nickName) {
    //   message.warning('请填写昵称');
    //   return
    // }
    const query = {
      nickName: this.state.nickName
    }
    axios.post('api-b/b/inst/edit/nickName', query).then((res) => {
      message.success('保存成功');
      Bus.trigger('changeNickName')
    })
  }

  render() {
    const { avatar, homeworkNotice, commentNotice, submitNotice, fileNotice } = this.state;
    return (
      <div className="page user-info">
        <div className="page-content">
          <section className="content-header">
            <h1>个人信息</h1>
          </section>
        </div>
        <div className="box first">
          <Form>
            <header className="title">个人信息</header>
            <FormItem
              label="个人头像"
              labelCol={{ span: 2 }}
            >
              <div id="avatar_edit" className="img-box" style={{ width: 54, height: 54, display: 'inline-block' }}>
                <UpLoad
                  addIcon={avatar ?
                    <span className="icon iconfont">&#xe60b;</span>
                    : <span
                      className="icon iconfont"
                      style={{ fontSize: '12px' }}
                    >上传头像</span>
                  }
                  width={54}
                  height={54}
                  img={avatar}
                  radius="50%"
                  onChange={img => {
                    this.state.banner = img;
                    axios.post("api-b/b/inst/edit/avatar", {
                      avatar: img,
                      adminId: window.currentUserInstInfo.adminId,
                    })
                      .then(res => {
                        this.setState({ avatar: img });
                        Bus.trigger('update_avatar', img);
                        message.success("头像上传成功");
                      });
                  }}
                />
              </div>
            </FormItem>
            <FormItem
              label="姓名"
              labelCol={{ span: 2 }}
            >
              <span>{window.currentUserInstInfo.adminName}</span>
            </FormItem>
            <FormItem
              label="昵称"
              labelCol={{ span: 2 }}
            >
              <Input
                id="nick_name_input"
                value={this.state.nickName}
                placeholder="昵称不能超过10个字符"
                style={{ width: 200 }}
                onChange={(event) => {
                  let nickName = event.target.value;
                  this.setState({ nickName });
                }} />
              <Row>
                <Col span={2}></Col>
                <Col>
                  <span className="icon iconfont" style={{ color: '#20A1FF', marginRight: 10 }}>&#xe64d;</span>“昵称”将用于家长端中的家校互动展示
                </Col>
              </Row>
            </FormItem>
            <FormItem>
              <Col span={2}></Col>
              <Button
                id="update_user_info_btn"
                onClick={this.handleEditNickName}
                type="primary" >
                更新信息
              </Button>
            </FormItem>
          </Form>
        </div>
        <div className="box">
          <header className="title">账号与密码</header>
          <PasswordModal />
        </div>
        <div className="box" style={{ marginBottom: 24 }}>
          <header className="title">新消息通知</header>
          <Form>
            {window.NewVersion && <FormItem
              label="作业提交提醒"
              labelCol={{ span: 3 }}
            >
              <Switch
                id="homework_notice_switch"
                checked={submitNotice}
                onChange={() => this.changeMessageControl(38, submitNotice ? 0 : 1)}
                style={{ marginLeft: 30 }}
              />
            </FormItem>}
            <FormItem
              label="作业回复提醒"
              labelCol={{ span: 3 }}
            >
              <Switch
                id="homework_notice_switch"
                checked={homeworkNotice}
                onChange={() => this.changeMessageControl(1, homeworkNotice ? 0 : 1)}
                style={{ marginLeft: 30 }}
              />
            </FormItem> 
            <FormItem
              label="点评回复提醒"
              labelCol={{ span: 3 }}
            >
              <Switch
                id="comment_notice_switch"
                checked={commentNotice}
                onChange={() => this.changeMessageControl(2, commentNotice ? 0 : 1)}
                style={{ marginLeft: 30 }}
              />
            </FormItem>
            {window.NewVersion && <FormItem
              label="成长档案回复提醒"
              labelCol={{ span: 3 }}
            >
              <Switch
                id="homework_notice_switch"
                checked={fileNotice}
                onChange={() => this.changeMessageControl(31, fileNotice ? 0 : 1)}
                style={{ marginLeft: 30 }}
              />
            </FormItem>}
          </Form>
        </div>
      </div>
    );
  }
}

UserInfo.contextType = HookContext;

export default withRouter(UserInfo);