import React, { useEffect, useState } from 'react';
import { Empty, ConfigProvider, Table } from 'antd';
import Lottie from 'react-lottie';
import * as nodata from '../modules/lottie/nodata/data.json';
import college from '@/common/lottie/college';

function XMTable(props) {
  const [empty, setEmpty] = useState(props.renderEmpty || {});
  const [data, setData] = useState({});
  const imgType = {
    college
  }

  useEffect(() => {
    setEmpty(props.renderEmpty || {})
    setData(props);
  }, [props]);

  // 自定义表格空状态
  function customizeRenderEmpty() {
    const defaultOptions = {
      loop: true,
      autoplay: true,
      animationData: empty.image || imgType[props?.renderEmpty?.type] || nodata,
      rendererSettings: {
        preserveAspectRatio: 'xMidYMid slice'
      }
    }
    return (
      <Empty
        image={<div style={{ marginTop: 24 }}>
          <Lottie
            options={defaultOptions}
            height={150}
            width={150}
            isStopped={false}
            isPaused={false}
          />
        </div>}
        imageStyle={{
          height: 150,
        }}
        description={empty.description}
      ></Empty>
    );
  };

  return (
    <ConfigProvider className="xm-table-component" renderEmpty={customizeRenderEmpty}>
      <Table
        {...data}
      />
    </ConfigProvider>
  )
}

export default XMTable;