/*
 * @Author: yuananting
 * @Date: 2021-08-05 17:09:36
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-06 17:23:31
 * @Description: 新建培训任务-选择指派对象
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from 'react';
import { Modal, Input, Tree, Dropdown, Tooltip, AutoComplete, Tabs } from 'antd';
import { XMTable } from '@/components';
// import college from '@/common/lottie/college.json';
// import Service from '@/common/js/service';
import User from '@/common/js/user';
// import SetEmployeeModal from './SetEmployeeModal';
// import search from '../../lottie/search/data.json';
// import MemberTree from '../components/MemberTree';
import { DepType } from '@/domains/store-domain/constants';
import StoreService from '@/domains/store-domain/storeService';
// import SearchUser from '../components/SearchUser';
import WWOpenDataCom from '@/components/WWOpenDataCom';
import './ChooseAssignorModal.less';
// import _ from 'underscore';

const { Search } = Input;
const { TabPane } = Tabs;
const { DirectoryTree } = Tree;

function ChooseAssignorModal(props) {
  const [structureData, setStructureData] = useState([]);
  const [activeKey, setActiveKey] = useState('departMentTab');

  useEffect(() => {
    getStructureData();
  }, [activeKey]);

  function getStructureData() {
    const params = {
      departmentTypeEnum: DepType[activeKey],
      enterpriseId: User.getEnterpriseId(),
      source: 0, // 0代表来自企培
      storeId: User.getStoreId(),
      userId: User.getUserId(),
      whetherCount: false,
    };
    StoreService.queryDepartmentTree(params).then((res) => {
      const { result = [] } = res;
      setStructureData(handleStructureData(result));
    });
  }

  function handleStructureData(dataArray) {
    const _dataArray = dataArray.map((item, index) => {
      item.key = item.id;
      if (item.sonDepartmentVOList) {
        item.children = item.sonDepartmentVOList;
        handleStructureData(item.sonDepartmentVOList);
      }
      return item;
    });
    return _dataArray;
  }

  function onSelectAssignor(value) {}

  return (
    <Modal
      className='choose-assignor-modal'
      title='添加指派对象'
      visible={true}
      // onCancel={props.onClose}
      onOk={() => {
        // props.onConfirm(seletedAssignorList);
        // props.onClose();
      }}
      width={680}
      maskClosable={false}>
      <div className='assignor-container'>
        <div className='left-list'>
          <Search
            placeholder='搜索学员、部门'
            // value={searchKey}
            // onChange={(e) => setSearchKey(e.target.value.trim())}
            className='search search-input'
            enterButton={<span className='icon iconfont'>&#xe832;</span>}
          />
          <div className='data-body'>
            <Tabs size={'small'} onChange={(key) => setActiveKey(key)}>
              <TabPane key='departMentTab' tab='部门'></TabPane>
              <TabPane key='postGrouptab' tab='岗位组'></TabPane>
              <TabPane key='customGroupTab' tab='自定义分组'></TabPane>
            </Tabs>
            <div className='tree-con'>
              <DirectoryTree
                defaultExpandAll
                checkable
                showIcon={false}
                treeData={structureData}
                // selectedKeys={selectedKeys}
                onSelect={onSelectAssignor}
                titleRender={(nodeData) => {
                  return (
                    <div className='node-title-div'>
                      <div className='item-icon'>
                        <span className='icon iconfont title-icon'>&#xe604;</span>
                      </div>
                      <div className='item-title'>
                        {activeKey === 'departMentTab' ? (
                          <span>
                            <WWOpenDataCom type='departmentName' openid={nodeData.name} />
                          </span>
                        ) : (
                          <span>{nodeData.name}</span>
                        )}
                      </div>
                    </div>
                  );
                }}
              />
            </div>
          </div>
        </div>
        <div className='right-list'>
          <div className='header-line'>
            <span className='tip-text'>已选择</span>
            <span className='clear-btn' onClick={() => {}}>
              清空
            </span>
          </div>
          <div className='data-body'></div>
        </div>
      </div>
    </Modal>
  );
}

export default ChooseAssignorModal;
