/*
 * @Author: yuananting
 * @Date: 2021-07-05 10:50:30
 * @LastEditors: yuananting
 * @LastEditTime: 2021-07-05 11:05:31
 * @Description: 描述一下咯
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Table, Modal, Input } from 'antd';
import PlanService from '@/domains/plan-domain/planService';
import User from '@/common/js/user';
import './UserLearnDetailModal.less';
import _ from 'underscore';
const defaultCover = 'https://image.xiaomaiketang.com/xm/YNfi45JwFA.png';
const CourseType = {
  LIVE: {
    text: '直播课',
  },
  VOICE: {
    text: '线上课',
  },
  RECORD: {
    text: '录播课',
  },
  PICTURE: {
    text: '图文课',
  },
};
const courseStateShow = {
  UN_START: {
    title: '待开播',
  },
  STARTING: {
    title: '直播中',
  },
  FINISH: {
    title: '回放',
  },
  EXPIRED: {
    title: '未成功开课',
  },
};
class UserLearnDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      planDataSource: {},
      taskDataSource: [],
      taskSize: 10,
      taskQuery: {
        current: 1,
      },
      taskTotalCount: 0,
      courseDataSource: [],
      storeCustomerName: '',
      storeCustomerPhone: '',
    };
  }
  componentDidMount() {
    this.getPlanCustomerDetail();
  }
  getPlanCustomerDetail = () => {
    PlanService.getPlanCustomerDetail({
      planId: getParameterByName('id'),
      storeCustomerId: this.props.storeCustomerId,
      storeId: User.getStoreId(),
    }).then((res) => {
      const { storeCustomerName, storeCustomerPhone, planName, learnFinishPercentage, taskCustomerVOList, courseMediaVOS } = res.result;
      let coverUrl;
      courseMediaVOS.map((item) => {
        if (item.contentType === 'COVER') {
          coverUrl = item.mediaUrl;
        }
        return item;
      });
      const planDataSource = {
        planName,
        learnFinishPercentage,
        coverUrl: coverUrl || defaultCover,
      };
      taskCustomerVOList.map((item) => {
        let videoClass =
          item.courseVOList &&
          item.courseVOList.filter((childItem, childIndex) => {
            return (childItem.courseType = 'VOICE');
          });
        videoClass.map((chapterItem, chapterIndex) => {
          chapterItem.chapterList = [
            {
              chapterName: '第一节1',
              percentage: '80%',
            },
            {
              chapterName: '第一节2',
              percentage: '10%',
            },
          ];
          return chapterItem;
        });
        return item;
      });
      this.setState({
        storeCustomerName,
        storeCustomerPhone,
        planDataSource,
        taskDataSource: taskCustomerVOList,
      });
    });
  };

  parsePlanDataColumns = () => {
    const columns = [
      {
        title: '培训计划名称',
        key: 'planName',
        dataIndex: 'planName',
        width: '77%',
        render: (val, record, index) => {
          return (
            <div className='record-name'>
              <div className='img-con'>
                <img src={record.coverUrl} />
              </div>
              <div>{record.planName}</div>
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record, index) => {
          return <div>{val}%</div>;
        },
      },
    ];
    return columns;
  };

  parseTaskColumns = () => {
    const columns = [
      {
        title: '培训任务',
        key: 'taskName',
        dataIndex: 'taskName',
        width: '68%',
        render: (val, record, index) => {
          return (
            <div className='taskName'>
              {index + 1}.{record.taskName}
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record) => {
          return <div className='task-learn-percentage'>{val === 100 ? <span>已完成</span> : <span>{val}%</span>}</div>;
        },
      },
    ];
    return columns;
  };

  parseCourseColumns = (parentIndex) => {
    const columns = [
      {
        title: '课程',
        key: 'courseName',
        dataIndex: 'courseName',
        width: '70%',
        render: (val, record, index) => {
          return (
            <div className='course-info'>
              <div>
                <span className='course-type'>{CourseType[record.courseType].text}</span>
                <span>
                  {parentIndex + 1}.{index + 1}&nbsp;
                </span>
              </div>
              <div className='name-and-state'>
                <span className='course-name'>{record.courseName}</span>
                {record.courseType === 'LIVE' && <span className='course-state'>{courseStateShow[record.courseState].title}</span>}
              </div>
            </div>
          );
        },
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record) => {
          return <div className='course-learn-percentage'>{record.learnState === 'FINISH' ? <span>已完成</span> : <span>{val}%</span>}</div>;
        },
      },
    ];
    return columns;
  };

  parseChapterColumns = (chapterIndex) => {
    const columns = [
      {
        title: '课节名称',
        key: 'chapterName',
        dataIndex: 'chapterName',
        width: '80%',
      },
      {
        title: '学习进度',
        key: 'percentage',
        dataIndex: 'percentage',
      },
    ];
    return columns;
  };

  render() {
    const { storeCustomerName, storeCustomerPhone, planDataSource, taskDataSource, taskQuery, taskTotalCount } = this.state;
    const { visible } = this.props;
    return (
      <Modal
        title='学员学习详情'
        onCancel={this.props.onClose}
        onOk={this.props.onClose}
        maskClosable={false}
        visible={visible}
        className='user-Learn-modal'
        closable={true}
        width={800}
        closeIcon={<span className='icon iconfont modal-close-icon'>&#xe6ef;</span>}>
        <div className='customer-info'>
          <span className='customer-name'>
            <span>学员：</span>
            <span>{storeCustomerName}</span>
          </span>
          <span className='customer-phone'>
            <span>手机号：</span>
            <span>{storeCustomerPhone}</span>
          </span>
        </div>
        <div className='table-box'>
          <Table className='plan-table' dataSource={[planDataSource]} columns={this.parsePlanDataColumns()} pagination={false} />
          <Table
            className='task-table'
            rowKey={(record) => record.taskId}
            dataSource={taskDataSource}
            columns={this.parseTaskColumns()}
            pagination={false}
            expandedRowRender={(record, index) => {
              if (!record.courseVOList) {
                return;
              }
              if (record.courseVOList.length !== 0) {
                return (
                  <div>
                    <Table
                      showHeader={false}
                      pagination={false}
                      dataSource={record.courseVOList}
                      columns={this.parseCourseColumns(index)}
                      className='child-table'
                      expandedRowRender={(chapterRecord, chapterIndex) => {
                        if (!chapterRecord.chapterList) {
                          return;
                        }
                        if (chapterRecord.chapterList.length !== 0) {
                          return (
                            <div>
                              <Table
                                showHeader={false}
                                pagination={false}
                                dataSource={chapterRecord.chapterList}
                                columns={this.parseChapterColumns(chapterIndex)}
                                className='chapter-table'
                              />
                            </div>
                          );
                        }
                      }}
                    />
                  </div>
                );
              }
            }}
            rowClassName={(record, index) => {
              if (index % 2 === 0) {
                return 'odd-row';
              } else {
                return 'even-row';
              }
            }}
          />
        </div>
      </Modal>
    );
  }
}

export default UserLearnDetailModal;
