import PropTypes from 'prop-types';
import React from 'react';
import { ConfigProvider, DatePicker } from 'antd';
import moment from 'moment';
import 'moment/locale/zh-cn';
import locale from 'antd/lib/locale/zh_CN';

const { RangePicker } = DatePicker;


class DateRangePicker extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    }
  }

  render() {
    const showTime = { showTime: false }
    return (
      <ConfigProvider locale={locale}>
        <RangePicker
          format={this.props.format || 'YYYY-MM-DD'}
          allowClear={this.props.allowClear}
          onChange={(date) => {
            if (!_.isEmpty(date)) {
              date[0] = date[0].startOf('day')
              date[1] = date[1].endOf('day')
            }
            this.props.onChange(date)
          }}
          {...showTime}
          suffixIcon={<span className="icon iconfont">&#xe838;</span>}
          {...this.props}
        />
      </ConfigProvider>
     
    )
  }

}

DateRangePicker.propTypes = {

};

DateRangePicker.defaultProps = {
  allowClear: true,
}

export default DateRangePicker;