import React, { useEffect, useState } from 'react';
import { Tabs } from 'antd';
import { Route, withRouter } from 'react-router-dom';
import Service from '@/common/js/service';
import Breadcrumbs from "@/components/Breadcrumbs";
import UserLearningData from './UserLearningData';
import DataInfo from './components/DataInfo'
import CourseTable from './components/CourseTable';
import DataAnalysic from './components/DataAnalysic';
import ExamTable from './components/ExamTable';
import StudyTable from './components/StudyTable';
import './index.less'
const { TabPane } = Tabs;

function DataCenter(props: any) {
    const { match } = props;
    const { params: { taskId }  } = match;
    const [info, setInfo] = useState<any>({})
    const [tabKey, setTabKey] = useState<any>('')


    const tabList = [
        {
            name: '课程目录',
            key: 'course',
            compoment: CourseTable,
            show:()=>{
                return true
            }
        },
        {
            name: '学习详情',
            key: 'study',
            compoment: StudyTable,
            show:()=>{
                return info.courseNum
            }
        },
        {
            name: '考试详情',
            key: 'exam',
            compoment: ExamTable,
            show:()=>{
                return info.examNum
            }
        },

    ]

    useEffect(() => {
        getInfo()
    }, [])

    function getInfo() {
        Service.Hades('/public/hades/getTrainingTaskDetail', { taskId }).then((res: any) => {
            res.result.trainingStageList.map((item: any) => {
                item.open = true
            })
            res.result.cover = res.result.courseMediaVOS.filter((item: any) => item.contentType === 'COVER')[0] || {};
            res.result.intro = res.result.courseMediaVOS.filter((item: any) => item.contentType === 'INTRO')[0] || {};
            setInfo(res.result)
        })
    }

    return <div className="page train-data-center">
        <Breadcrumbs
            navList="培训任务详情"
            goBack={() => {
                props.history.goBack();
            }}
        />
        <div className="content">
            <DataInfo info={info} />
            <Tabs defaultActiveKey={'course'} onChange={() => { }}>
                {
                    tabList.map((item: any) => {
                        return item.show() && <TabPane tab={item.name} key={item.key}>
                            {
                                <item.compoment info={info} taskId={taskId} />
                            }
                        </TabPane>
                    })
                }

            </Tabs>
        </div>
        <Route
            path={`${match.url}/analysic/:id`}
            render={() => {
                return <DataAnalysic />;
            }}
        />
         <Route path={`${props.match.url}/user-learning-data/:storeCustomerId`} render={() => <UserLearningData taskId={taskId} />} />
    </div>
}

export default withRouter(DataCenter)
