/*
 * @Author: zhangyi 
 * @Date: 2020-02-07 14:35:21 
 * @Last Modified by: chenshu
 * @Last Modified time: 2020-09-10 15:30:29
 */
import React, { useEffect, useState } from 'react';
import './TeacherTip.less';


class TeacherTip extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      
    }
  }
  goclick = () => {
    if (window.NewVersion) {
      window.open("https://b.xiaomai5.com/#/login", "_blank");
    } else {
      window.open("https://b.xiaomai5.com/teacher.html", "_blank");
    }
    
  };
  
  render() {
    const { isXiaomai } = this.props;
    return (
      <div className="teacher__container">
        <div className="teacher__container__child teacher">
          <div className="teacher__child__title"> <span>上课老师如何直播？</span></div>
          {window.NewVersion ?
            <div className="teacher__child__box">
              <div className="teacher__child__box__item">
                <img src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/pFbfzS5TEnrMCPTGTG6JifJ67SW7EajfXatWrSWY8HKkTPWs1581060346720" className="teacher__img" />
                <p>进入直播课表</p>
                <div className="teacher__child__box__item__text">新建直播课、设置上课时间、选择上课学员，选择上课老师</div>
              </div>
              <div className="teacher__child__box__item ml10">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/JXA6WzYWABrkMtT2SzNPFAQR2tMNfMhD7rr4PQJGmad8w7s81581060291294" className="teacher__img" />
                <p>课前准备</p>
                <div className="teacher__child__box__item__text">准备PPT等课件、下载直播客户端、发送学员上课通知</div>
              </div>
              <div className="teacher__child__box__item ml10">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/5CwYmctQdCdeQaMBJHeawhDNfd35jRCQ4MzQNnZDR5WtbbDf1581060318175" className="teacher__img" />
                
                <p>开始上课</p>
                <div className="teacher__child__box__item__text">上课老师账号点击“开始上课”，唤起直播客户端进入直播间授课</div>
              </div>
            </div>
            :<div className="teacher__child__box">
              <div className="teacher__child__box__item">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/JXA6WzYWABrkMtT2SzNPFAQR2tMNfMhD7rr4PQJGmad8w7s81581060291294" className="teacher__img" />
                <p>课前准备</p>
                <div className="teacher__child__box__item__text">准备PPT等课件、下载直播客户端、发送学员上课通知</div>
              </div>
              <div className="teacher__child__box__item ml10">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/pFbfzS5TEnrMCPTGTG6JifJ67SW7EajfXatWrSWY8HKkTPWs1581060346720" className="teacher__img" />
                <p>登录电脑端</p>
                <div className="teacher__child__box__item__text">直播课表<span style={{color:'#FF7519',fontSize:'14px',cursor:'pointer'}} onClick={() => {this.goclick()}}>{window.NewVersion ? 'https://b.xiaomai5.com/#/login':'https://b.xiaomai5.com/teacher.html'}</span></div>
              </div>
              <div className="teacher__child__box__item ml10">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/5CwYmctQdCdeQaMBJHeawhDNfd35jRCQ4MzQNnZDR5WtbbDf1581060318175" className="teacher__img" />
                
                <p>进入直播课表</p>
                <div className="teacher__child__box__item__text">通过微信家长端“服务”页面，点击“直播课”，进入直播课表</div>
              </div>
            </div>
          }
        </div>
        <div className="teacher__container__child student">
          <div className="teacher__child__title"><span>学员如何观看直播？</span></div>
          {isXiaomai ?
            <div className="teacher__child__box">
              <div className="teacher__child__box__item">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1584348178767.png?x-oss-process=image/resize,w_300,limit_0"  className="student__img"/>
                <p>进入直播课表</p>
                <div className="teacher__child__box__item__text">通过应用市场搜索“每课学堂APP“，进入直播课表</div>
              </div>
              <div className="teacher__child__box__item ml37">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1584348215146.png?x-oss-process=image/resize,w_300,limit_0" className="student__img" />
                <p>找到直播课</p>
                <div className="teacher__child__box__item__text">在直播课的课表中，找到本次需要上的直播课</div>
              </div>
              <div className="teacher__child__box__item ml37">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1584348242614.png?x-oss-process=image/resize,w_300,limit_0" className="student__img"/>
                <p>进入直播间</p>
                <div className="teacher__child__box__item__text">在“直播课详情”页中，点击“进入直播间”按钮，进入直播间</div>
              </div>
            </div>
            : <div className="teacher__child__box">
              <div className="teacher__child__box__item">
             <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/MzXs4GCmTsQ5SEeB5ZKdQbstrZD3mfcKDtZpFzZS723P48jc1581149424829"  className="student__img"/>
                <p>进入家长端</p>
                <div className="teacher__child__box__item__text">在“家长端-服务”中找到“直播课”的入口</div>
              </div>
              <div className="teacher__child__box__item ml37">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/DcxB2QhepAJ43xYwQ6tyDrdmyTQwFZzWwmwmeTPbaNEpADY81581060047852" className="student__img" />
                <p>找到直播课</p>
                <div className="teacher__child__box__item__text">在直播课的课表中，找到本次需要上的直播课</div>
              </div>
              <div className="teacher__child__box__item ml37">
               <img  src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/pyzPekG6EsG7Y3JH28KKdJJFb3xKNfXMHWwY8kdzFbjEjmb31581060110133" className="student__img"/>
                <p>进入直播间</p>
                <div className="teacher__child__box__item__text">在“直播课详情”页中，点击“进入直播间”按钮，进入直播间</div>
              </div>
            </div>
          }
        </div>
      </div>
    )
  }
}
export default TeacherTip;